/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.AffectedHistory;

public final class ImmutableAffectedHistory
implements AffectedHistory {
    private final int identifier;
    private final int pts;
    private final int ptsCount;
    private final int offset;

    private ImmutableAffectedHistory(int pts, int ptsCount, int offset) {
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.offset = offset;
        this.identifier = AffectedHistory.super.identifier();
    }

    private ImmutableAffectedHistory(Builder builder) {
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.offset = builder.offset;
        this.identifier = builder.identifierIsSet() ? builder.identifier : AffectedHistory.super.identifier();
    }

    private ImmutableAffectedHistory(int identifier, int pts, int ptsCount, int offset) {
        this.identifier = identifier;
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.offset = offset;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    public final ImmutableAffectedHistory withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAffectedHistory(value, this.pts, this.ptsCount, this.offset);
    }

    public final ImmutableAffectedHistory withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableAffectedHistory(this.identifier, value, this.ptsCount, this.offset);
    }

    public final ImmutableAffectedHistory withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableAffectedHistory(this.identifier, this.pts, value, this.offset);
    }

    public final ImmutableAffectedHistory withOffset(int value) {
        if (this.offset == value) {
            return this;
        }
        return new ImmutableAffectedHistory(this.identifier, this.pts, this.ptsCount, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAffectedHistory && this.equalTo(0, (ImmutableAffectedHistory)another);
    }

    private boolean equalTo(int synthetic, ImmutableAffectedHistory another) {
        return this.identifier == another.identifier && this.pts == another.pts && this.ptsCount == another.ptsCount && this.offset == another.offset;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        h += (h << 5) + this.offset;
        return h;
    }

    public String toString() {
        return "AffectedHistory{identifier=" + this.identifier + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + ", offset=" + this.offset + "}";
    }

    public static ImmutableAffectedHistory of(int pts, int ptsCount, int offset) {
        return new ImmutableAffectedHistory(pts, ptsCount, offset);
    }

    public static ImmutableAffectedHistory copyOf(AffectedHistory instance) {
        if (instance instanceof ImmutableAffectedHistory) {
            return (ImmutableAffectedHistory)instance;
        }
        return ImmutableAffectedHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PTS = 1L;
        private static final long INIT_BIT_PTS_COUNT = 2L;
        private static final long INIT_BIT_OFFSET = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int pts;
        private int ptsCount;
        private int offset;

        private Builder() {
        }

        public final Builder from(AffectedHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AffectedHistory instance;
            long bits = 0L;
            if (object instanceof AffectedHistory) {
                instance = (AffectedHistory)object;
                this.ptsCount(instance.ptsCount());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.offset(instance.offset());
                this.pts(instance.pts());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offset(int offset) {
            this.offset = offset;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableAffectedHistory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAffectedHistory(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ptsCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("offset");
            }
            return "Cannot build AffectedHistory, some of required attributes are not set " + attributes;
        }
    }
}

