/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.AffectedMessages;

public final class ImmutableAffectedMessages
implements AffectedMessages {
    private final int identifier;
    private final int pts;
    private final int ptsCount;

    private ImmutableAffectedMessages(int pts, int ptsCount) {
        this.pts = pts;
        this.ptsCount = ptsCount;
        this.identifier = AffectedMessages.super.identifier();
    }

    private ImmutableAffectedMessages(Builder builder) {
        this.pts = builder.pts;
        this.ptsCount = builder.ptsCount;
        this.identifier = builder.identifierIsSet() ? builder.identifier : AffectedMessages.super.identifier();
    }

    private ImmutableAffectedMessages(int identifier, int pts, int ptsCount) {
        this.identifier = identifier;
        this.pts = pts;
        this.ptsCount = ptsCount;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int ptsCount() {
        return this.ptsCount;
    }

    public final ImmutableAffectedMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAffectedMessages(value, this.pts, this.ptsCount);
    }

    public final ImmutableAffectedMessages withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableAffectedMessages(this.identifier, value, this.ptsCount);
    }

    public final ImmutableAffectedMessages withPtsCount(int value) {
        if (this.ptsCount == value) {
            return this;
        }
        return new ImmutableAffectedMessages(this.identifier, this.pts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAffectedMessages && this.equalTo(0, (ImmutableAffectedMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableAffectedMessages another) {
        return this.identifier == another.identifier && this.pts == another.pts && this.ptsCount == another.ptsCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.pts;
        h += (h << 5) + this.ptsCount;
        return h;
    }

    public String toString() {
        return "AffectedMessages{identifier=" + this.identifier + ", pts=" + this.pts + ", ptsCount=" + this.ptsCount + "}";
    }

    public static ImmutableAffectedMessages of(int pts, int ptsCount) {
        return new ImmutableAffectedMessages(pts, ptsCount);
    }

    public static ImmutableAffectedMessages copyOf(AffectedMessages instance) {
        if (instance instanceof ImmutableAffectedMessages) {
            return (ImmutableAffectedMessages)instance;
        }
        return ImmutableAffectedMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PTS = 1L;
        private static final long INIT_BIT_PTS_COUNT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int pts;
        private int ptsCount;

        private Builder() {
        }

        public final Builder from(AffectedMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AffectedMessages instance;
            long bits = 0L;
            if (object instanceof AffectedMessages) {
                instance = (AffectedMessages)object;
                this.ptsCount(instance.ptsCount());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.pts(instance.pts());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ptsCount(int ptsCount) {
            this.ptsCount = ptsCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAffectedMessages build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAffectedMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ptsCount");
            }
            return "Cannot build AffectedMessages, some of required attributes are not set " + attributes;
        }
    }
}

