/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.StickerSetCovered;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.ArchivedStickers;

public final class ImmutableArchivedStickers
implements ArchivedStickers {
    private final int identifier;
    private final int count;
    private final List<StickerSetCovered> sets;

    private ImmutableArchivedStickers(int count) {
        this.count = count;
        this.sets = Collections.emptyList();
        this.identifier = ArchivedStickers.super.identifier();
    }

    private ImmutableArchivedStickers(Builder builder) {
        this.count = builder.count;
        this.sets = ImmutableArchivedStickers.createUnmodifiableList(true, builder.sets);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ArchivedStickers.super.identifier();
    }

    private ImmutableArchivedStickers(int identifier, int count, List<StickerSetCovered> sets) {
        this.identifier = identifier;
        this.count = count;
        this.sets = sets;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<StickerSetCovered> sets() {
        return this.sets;
    }

    public final ImmutableArchivedStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableArchivedStickers(value, this.count, this.sets);
    }

    public final ImmutableArchivedStickers withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableArchivedStickers(this.identifier, value, this.sets);
    }

    public final ImmutableArchivedStickers withSets(StickerSetCovered ... elements) {
        List<StickerSetCovered> newValue = ImmutableArchivedStickers.createUnmodifiableList(false, ImmutableArchivedStickers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableArchivedStickers(this.identifier, this.count, newValue);
    }

    public final ImmutableArchivedStickers withSets(Iterable<? extends StickerSetCovered> elements) {
        if (this.sets == elements) {
            return this;
        }
        List<StickerSetCovered> newValue = ImmutableArchivedStickers.createUnmodifiableList(false, ImmutableArchivedStickers.createSafeList(elements, true, false));
        return new ImmutableArchivedStickers(this.identifier, this.count, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableArchivedStickers && this.equalTo(0, (ImmutableArchivedStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableArchivedStickers another) {
        return this.identifier == another.identifier && this.count == another.count && this.sets.equals(another.sets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.count;
        h += (h << 5) + this.sets.hashCode();
        return h;
    }

    public String toString() {
        return "ArchivedStickers{identifier=" + this.identifier + ", count=" + this.count + ", sets=" + this.sets + "}";
    }

    public static ImmutableArchivedStickers of(int count) {
        return new ImmutableArchivedStickers(count);
    }

    public static ImmutableArchivedStickers copyOf(ArchivedStickers instance) {
        if (instance instanceof ImmutableArchivedStickers) {
            return (ImmutableArchivedStickers)instance;
        }
        return ImmutableArchivedStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int count;
        private List<StickerSetCovered> sets = new ArrayList<StickerSetCovered>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ArchivedStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ArchivedStickers) {
                instance = (ArchivedStickers)object;
                this.addAllSets(instance.sets());
                this.count(instance.count());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSet(StickerSetCovered element) {
            this.sets.add(Objects.requireNonNull(element, "sets element"));
            return this;
        }

        public final Builder addSets(StickerSetCovered ... elements) {
            for (StickerSetCovered element : elements) {
                this.sets.add(Objects.requireNonNull(element, "sets element"));
            }
            return this;
        }

        public final Builder sets(Iterable<? extends StickerSetCovered> elements) {
            this.sets.clear();
            return this.addAllSets(elements);
        }

        public final Builder addAllSets(Iterable<? extends StickerSetCovered> elements) {
            for (StickerSetCovered stickerSetCovered : elements) {
                this.sets.add(Objects.requireNonNull(stickerSetCovered, "sets element"));
            }
            return this;
        }

        public ImmutableArchivedStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableArchivedStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build ArchivedStickers, some of required attributes are not set " + attributes;
        }
    }
}

