/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.StickerSet;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.AllStickers;
import telegram4j.tl.messages.BaseAllStickers;

public final class ImmutableBaseAllStickers
implements BaseAllStickers {
    private final int identifier;
    private final long hash;
    private final List<StickerSet> sets;

    private ImmutableBaseAllStickers(long hash) {
        this.hash = hash;
        this.sets = Collections.emptyList();
        this.identifier = BaseAllStickers.super.identifier();
    }

    private ImmutableBaseAllStickers(Builder builder) {
        this.hash = builder.hash;
        this.sets = ImmutableBaseAllStickers.createUnmodifiableList(true, builder.sets);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseAllStickers.super.identifier();
    }

    private ImmutableBaseAllStickers(int identifier, long hash, List<StickerSet> sets) {
        this.identifier = identifier;
        this.hash = hash;
        this.sets = sets;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public List<StickerSet> sets() {
        return this.sets;
    }

    public final ImmutableBaseAllStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseAllStickers(value, this.hash, this.sets);
    }

    public final ImmutableBaseAllStickers withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseAllStickers(this.identifier, value, this.sets);
    }

    public final ImmutableBaseAllStickers withSets(StickerSet ... elements) {
        List<StickerSet> newValue = ImmutableBaseAllStickers.createUnmodifiableList(false, ImmutableBaseAllStickers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseAllStickers(this.identifier, this.hash, newValue);
    }

    public final ImmutableBaseAllStickers withSets(Iterable<? extends StickerSet> elements) {
        if (this.sets == elements) {
            return this;
        }
        List<StickerSet> newValue = ImmutableBaseAllStickers.createUnmodifiableList(false, ImmutableBaseAllStickers.createSafeList(elements, true, false));
        return new ImmutableBaseAllStickers(this.identifier, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseAllStickers && this.equalTo(0, (ImmutableBaseAllStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseAllStickers another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.sets.equals(another.sets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.sets.hashCode();
        return h;
    }

    public String toString() {
        return "BaseAllStickers{identifier=" + this.identifier + ", hash=" + this.hash + ", sets=" + this.sets + "}";
    }

    public static ImmutableBaseAllStickers of(long hash) {
        return new ImmutableBaseAllStickers(hash);
    }

    public static ImmutableBaseAllStickers copyOf(BaseAllStickers instance) {
        if (instance instanceof ImmutableBaseAllStickers) {
            return (ImmutableBaseAllStickers)instance;
        }
        return ImmutableBaseAllStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;
        private List<StickerSet> sets = new ArrayList<StickerSet>();

        private Builder() {
        }

        public final Builder from(AllStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseAllStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AllStickers instance;
            long bits = 0L;
            if (object instanceof AllStickers) {
                instance = (AllStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseAllStickers) {
                instance = (BaseAllStickers)object;
                this.addAllSets(instance.sets());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSet(StickerSet element) {
            this.sets.add(Objects.requireNonNull(element, "sets element"));
            return this;
        }

        public final Builder addSets(StickerSet ... elements) {
            for (StickerSet element : elements) {
                this.sets.add(Objects.requireNonNull(element, "sets element"));
            }
            return this;
        }

        public final Builder sets(Iterable<? extends StickerSet> elements) {
            this.sets.clear();
            return this.addAllSets(elements);
        }

        public final Builder addAllSets(Iterable<? extends StickerSet> elements) {
            for (StickerSet stickerSet : elements) {
                this.sets.add(Objects.requireNonNull(stickerSet, "sets element"));
            }
            return this;
        }

        public ImmutableBaseAllStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseAllStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseAllStickers, some of required attributes are not set " + attributes;
        }
    }
}

