/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.AvailableReaction;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.AvailableReactions;
import telegram4j.tl.messages.BaseAvailableReactions;

public final class ImmutableBaseAvailableReactions
implements BaseAvailableReactions {
    private final int identifier;
    private final int hash;
    private final List<AvailableReaction> reactions;

    private ImmutableBaseAvailableReactions(int hash) {
        this.hash = hash;
        this.reactions = Collections.emptyList();
        this.identifier = BaseAvailableReactions.super.identifier();
    }

    private ImmutableBaseAvailableReactions(Builder builder) {
        this.hash = builder.hash;
        this.reactions = ImmutableBaseAvailableReactions.createUnmodifiableList(true, builder.reactions);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseAvailableReactions.super.identifier();
    }

    private ImmutableBaseAvailableReactions(int identifier, int hash, List<AvailableReaction> reactions) {
        this.identifier = identifier;
        this.hash = hash;
        this.reactions = reactions;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    @Override
    public List<AvailableReaction> reactions() {
        return this.reactions;
    }

    public final ImmutableBaseAvailableReactions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseAvailableReactions(value, this.hash, this.reactions);
    }

    public final ImmutableBaseAvailableReactions withHash(int value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseAvailableReactions(this.identifier, value, this.reactions);
    }

    public final ImmutableBaseAvailableReactions withReactions(AvailableReaction ... elements) {
        List<AvailableReaction> newValue = ImmutableBaseAvailableReactions.createUnmodifiableList(false, ImmutableBaseAvailableReactions.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseAvailableReactions(this.identifier, this.hash, newValue);
    }

    public final ImmutableBaseAvailableReactions withReactions(Iterable<? extends AvailableReaction> elements) {
        if (this.reactions == elements) {
            return this;
        }
        List<AvailableReaction> newValue = ImmutableBaseAvailableReactions.createUnmodifiableList(false, ImmutableBaseAvailableReactions.createSafeList(elements, true, false));
        return new ImmutableBaseAvailableReactions(this.identifier, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseAvailableReactions && this.equalTo(0, (ImmutableBaseAvailableReactions)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseAvailableReactions another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.reactions.equals(another.reactions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.hash;
        h += (h << 5) + this.reactions.hashCode();
        return h;
    }

    public String toString() {
        return "BaseAvailableReactions{identifier=" + this.identifier + ", hash=" + this.hash + ", reactions=" + this.reactions + "}";
    }

    public static ImmutableBaseAvailableReactions of(int hash) {
        return new ImmutableBaseAvailableReactions(hash);
    }

    public static ImmutableBaseAvailableReactions copyOf(BaseAvailableReactions instance) {
        if (instance instanceof ImmutableBaseAvailableReactions) {
            return (ImmutableBaseAvailableReactions)instance;
        }
        return ImmutableBaseAvailableReactions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int hash;
        private List<AvailableReaction> reactions = new ArrayList<AvailableReaction>();

        private Builder() {
        }

        public final Builder from(BaseAvailableReactions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AvailableReactions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AvailableReactions instance;
            long bits = 0L;
            if (object instanceof BaseAvailableReactions) {
                instance = (BaseAvailableReactions)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllReactions(instance.reactions());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof AvailableReactions) {
                instance = (AvailableReactions)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(int hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addReaction(AvailableReaction element) {
            this.reactions.add(Objects.requireNonNull(element, "reactions element"));
            return this;
        }

        public final Builder addReactions(AvailableReaction ... elements) {
            for (AvailableReaction element : elements) {
                this.reactions.add(Objects.requireNonNull(element, "reactions element"));
            }
            return this;
        }

        public final Builder reactions(Iterable<? extends AvailableReaction> elements) {
            this.reactions.clear();
            return this.addAllReactions(elements);
        }

        public final Builder addAllReactions(Iterable<? extends AvailableReaction> elements) {
            for (AvailableReaction availableReaction : elements) {
                this.reactions.add(Objects.requireNonNull(availableReaction, "reactions element"));
            }
            return this;
        }

        public ImmutableBaseAvailableReactions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseAvailableReactions(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseAvailableReactions, some of required attributes are not set " + attributes;
        }
    }
}

