/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BaseChats;
import telegram4j.tl.messages.Chats;

public final class ImmutableBaseChats
implements BaseChats {
    private final int identifier;
    private final List<Chat> chats;

    private ImmutableBaseChats(Builder builder) {
        this.chats = ImmutableBaseChats.createUnmodifiableList(true, builder.chats);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseChats.super.identifier();
    }

    private ImmutableBaseChats(int identifier, List<Chat> chats) {
        this.identifier = identifier;
        this.chats = chats;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    public final ImmutableBaseChats withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseChats(value, this.chats);
    }

    public final ImmutableBaseChats withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableBaseChats.createUnmodifiableList(false, ImmutableBaseChats.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseChats(this.identifier, newValue);
    }

    public final ImmutableBaseChats withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableBaseChats.createUnmodifiableList(false, ImmutableBaseChats.createSafeList(elements, true, false));
        return new ImmutableBaseChats(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseChats && this.equalTo(0, (ImmutableBaseChats)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseChats another) {
        return this.identifier == another.identifier && this.chats.equals(another.chats);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.chats.hashCode();
        return h;
    }

    public String toString() {
        return "BaseChats{identifier=" + this.identifier + ", chats=" + this.chats + "}";
    }

    public static ImmutableBaseChats copyOf(BaseChats instance) {
        if (instance instanceof ImmutableBaseChats) {
            return (ImmutableBaseChats)instance;
        }
        return ImmutableBaseChats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Chat> chats = new ArrayList<Chat>();

        private Builder() {
        }

        public final Builder from(Chats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseChats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Chats instance;
            long bits = 0L;
            if (object instanceof Chats) {
                instance = (Chats)object;
                if ((bits & 2L) == 0L) {
                    this.addAllChats(instance.chats());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseChats) {
                instance = (BaseChats)object;
                if ((bits & 2L) == 0L) {
                    this.addAllChats(instance.chats());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public ImmutableBaseChats build() {
            return new ImmutableBaseChats(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

