/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BaseDhConfig;
import telegram4j.tl.messages.DhConfig;

public final class ImmutableBaseDhConfig
implements BaseDhConfig {
    private final int identifier;
    private final int g;
    private final ByteBuf p;
    private final int version;
    private final ByteBuf random;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseDhConfig(int g, int version) {
        this.g = g;
        this.version = version;
        this.p = null;
        this.random = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseDhConfig(Builder builder) {
        this.g = builder.g;
        this.p = builder.p_build();
        this.version = builder.version;
        this.random = builder.random_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableBaseDhConfig(int identifier, int g, ByteBuf p, int version, ByteBuf random) {
        this.identifier = identifier;
        this.g = g;
        this.p = p;
        this.version = version;
        this.random = random;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseDhConfig.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int g() {
        return this.g;
    }

    @Override
    public ByteBuf p() {
        return this.p.duplicate();
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public ByteBuf random() {
        return this.random.duplicate();
    }

    public final ImmutableBaseDhConfig withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseDhConfig(value, this.g, this.p, this.version, this.random);
    }

    public final ImmutableBaseDhConfig withG(int value) {
        if (this.g == value) {
            return this;
        }
        return new ImmutableBaseDhConfig(this.identifier, value, this.p, this.version, this.random);
    }

    public ImmutableBaseDhConfig withP(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.p == newValue) {
            return this;
        }
        return new ImmutableBaseDhConfig(this.identifier, this.g, newValue, this.version, this.random);
    }

    public final ImmutableBaseDhConfig withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableBaseDhConfig(this.identifier, this.g, this.p, value, this.random);
    }

    public ImmutableBaseDhConfig withRandom(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.random == newValue) {
            return this;
        }
        return new ImmutableBaseDhConfig(this.identifier, this.g, this.p, this.version, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseDhConfig && this.equalTo(0, (ImmutableBaseDhConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseDhConfig another) {
        return this.identifier == another.identifier && this.g == another.g && this.p().equals((Object)another.p()) && this.version == another.version && this.random().equals((Object)another.random());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.g;
        h += (h << 5) + this.p().hashCode();
        h += (h << 5) + this.version;
        h += (h << 5) + this.random().hashCode();
        return h;
    }

    public String toString() {
        return "BaseDhConfig{identifier=" + this.identifier + ", g=" + this.g + ", p=" + ByteBufUtil.hexDump((ByteBuf)this.p) + ", version=" + this.version + ", random=" + ByteBufUtil.hexDump((ByteBuf)this.random) + "}";
    }

    public static ImmutableBaseDhConfig of(int g, int version) {
        return new ImmutableBaseDhConfig(g, version);
    }

    public static ImmutableBaseDhConfig copyOf(BaseDhConfig instance) {
        if (instance instanceof ImmutableBaseDhConfig) {
            return (ImmutableBaseDhConfig)instance;
        }
        return ImmutableBaseDhConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_G = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf p_value = null;
        private ByteBuf random_value = null;
        private int identifier;
        private int g;
        private int version;

        private Builder() {
        }

        public final Builder from(BaseDhConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DhConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DhConfig instance;
            long bits = 0L;
            if (object instanceof BaseDhConfig) {
                instance = (BaseDhConfig)object;
                this.p(instance.p());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.random(instance.random());
                    bits |= 2L;
                }
                this.version(instance.version());
                this.g(instance.g());
            }
            if (object instanceof DhConfig) {
                instance = (DhConfig)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.random(instance.random());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder g(int g) {
            this.g = g;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder p(ByteBuf value) {
            this.p_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder random(ByteBuf value) {
            this.random_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableBaseDhConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseDhConfig(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("g");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build BaseDhConfig, some of required attributes are not set " + attributes;
        }

        private ByteBuf p_build() {
            return Objects.requireNonNull(this.p_value);
        }

        private ByteBuf random_build() {
            return Objects.requireNonNull(this.random_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseDhConfig.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build BaseDhConfig, attribute initializers form cycle " + attributes;
        }
    }
}

