/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.Dialog;
import telegram4j.tl.Message;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BaseDialogs;
import telegram4j.tl.messages.Dialogs;

public final class ImmutableBaseDialogs
implements BaseDialogs {
    private final int identifier;
    private final List<Dialog> dialogs;
    private final List<Message> messages;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableBaseDialogs(Builder builder) {
        this.dialogs = ImmutableBaseDialogs.createUnmodifiableList(true, builder.dialogs);
        this.messages = ImmutableBaseDialogs.createUnmodifiableList(true, builder.messages);
        this.chats = ImmutableBaseDialogs.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableBaseDialogs.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseDialogs.super.identifier();
    }

    private ImmutableBaseDialogs(int identifier, List<Dialog> dialogs, List<Message> messages, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.dialogs = dialogs;
        this.messages = messages;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Dialog> dialogs() {
        return this.dialogs;
    }

    @Override
    public List<Message> messages() {
        return this.messages;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableBaseDialogs withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseDialogs(value, this.dialogs, this.messages, this.chats, this.users);
    }

    public final ImmutableBaseDialogs withDialogs(Dialog ... elements) {
        List<Dialog> newValue = ImmutableBaseDialogs.createUnmodifiableList(false, ImmutableBaseDialogs.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDialogs(this.identifier, newValue, this.messages, this.chats, this.users);
    }

    public final ImmutableBaseDialogs withDialogs(Iterable<? extends Dialog> elements) {
        if (this.dialogs == elements) {
            return this;
        }
        List<Dialog> newValue = ImmutableBaseDialogs.createUnmodifiableList(false, ImmutableBaseDialogs.createSafeList(elements, true, false));
        return new ImmutableBaseDialogs(this.identifier, newValue, this.messages, this.chats, this.users);
    }

    public final ImmutableBaseDialogs withMessages(Message ... elements) {
        List<Message> newValue = ImmutableBaseDialogs.createUnmodifiableList(false, ImmutableBaseDialogs.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDialogs(this.identifier, this.dialogs, newValue, this.chats, this.users);
    }

    public final ImmutableBaseDialogs withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Message> newValue = ImmutableBaseDialogs.createUnmodifiableList(false, ImmutableBaseDialogs.createSafeList(elements, true, false));
        return new ImmutableBaseDialogs(this.identifier, this.dialogs, newValue, this.chats, this.users);
    }

    public final ImmutableBaseDialogs withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableBaseDialogs.createUnmodifiableList(false, ImmutableBaseDialogs.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDialogs(this.identifier, this.dialogs, this.messages, newValue, this.users);
    }

    public final ImmutableBaseDialogs withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableBaseDialogs.createUnmodifiableList(false, ImmutableBaseDialogs.createSafeList(elements, true, false));
        return new ImmutableBaseDialogs(this.identifier, this.dialogs, this.messages, newValue, this.users);
    }

    public final ImmutableBaseDialogs withUsers(User ... elements) {
        List<User> newValue = ImmutableBaseDialogs.createUnmodifiableList(false, ImmutableBaseDialogs.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseDialogs(this.identifier, this.dialogs, this.messages, this.chats, newValue);
    }

    public final ImmutableBaseDialogs withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBaseDialogs.createUnmodifiableList(false, ImmutableBaseDialogs.createSafeList(elements, true, false));
        return new ImmutableBaseDialogs(this.identifier, this.dialogs, this.messages, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseDialogs && this.equalTo(0, (ImmutableBaseDialogs)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseDialogs another) {
        return this.identifier == another.identifier && this.dialogs.equals(another.dialogs) && this.messages.equals(another.messages) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.dialogs.hashCode();
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "BaseDialogs{identifier=" + this.identifier + ", dialogs=" + this.dialogs + ", messages=" + this.messages + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableBaseDialogs copyOf(BaseDialogs instance) {
        if (instance instanceof ImmutableBaseDialogs) {
            return (ImmutableBaseDialogs)instance;
        }
        return ImmutableBaseDialogs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Dialog> dialogs = new ArrayList<Dialog>();
        private List<Message> messages = new ArrayList<Message>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(Dialogs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseDialogs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Dialogs instance;
            long bits = 0L;
            if (object instanceof Dialogs) {
                instance = (Dialogs)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseDialogs) {
                instance = (BaseDialogs)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllMessages(instance.messages());
                this.addAllDialogs(instance.dialogs());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addDialog(Dialog element) {
            this.dialogs.add(Objects.requireNonNull(element, "dialogs element"));
            return this;
        }

        public final Builder addDialogs(Dialog ... elements) {
            for (Dialog element : elements) {
                this.dialogs.add(Objects.requireNonNull(element, "dialogs element"));
            }
            return this;
        }

        public final Builder dialogs(Iterable<? extends Dialog> elements) {
            this.dialogs.clear();
            return this.addAllDialogs(elements);
        }

        public final Builder addAllDialogs(Iterable<? extends Dialog> elements) {
            for (Dialog dialog : elements) {
                this.dialogs.add(Objects.requireNonNull(dialog, "dialogs element"));
            }
            return this;
        }

        public final Builder addMessage(Message element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(Message ... elements) {
            for (Message element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            for (Message message : elements) {
                this.messages.add(Objects.requireNonNull(message, "messages element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableBaseDialogs build() {
            return new ImmutableBaseDialogs(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

