/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.ExportedChatInvite;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BaseExportedChatInvite;

public final class ImmutableBaseExportedChatInvite
implements BaseExportedChatInvite {
    private final int identifier;
    private final ExportedChatInvite invite;
    private final List<User> users;

    private ImmutableBaseExportedChatInvite(ExportedChatInvite invite) {
        this.invite = Objects.requireNonNull(invite, "invite");
        this.users = Collections.emptyList();
        this.identifier = BaseExportedChatInvite.super.identifier();
    }

    private ImmutableBaseExportedChatInvite(Builder builder) {
        this.invite = builder.invite;
        this.users = ImmutableBaseExportedChatInvite.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseExportedChatInvite.super.identifier();
    }

    private ImmutableBaseExportedChatInvite(int identifier, ExportedChatInvite invite, List<User> users) {
        this.identifier = identifier;
        this.invite = invite;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public ExportedChatInvite invite() {
        return this.invite;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableBaseExportedChatInvite withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseExportedChatInvite(value, this.invite, this.users);
    }

    public final ImmutableBaseExportedChatInvite withInvite(ExportedChatInvite value) {
        if (this.invite == value) {
            return this;
        }
        ExportedChatInvite newValue = Objects.requireNonNull(value, "invite");
        return new ImmutableBaseExportedChatInvite(this.identifier, newValue, this.users);
    }

    public final ImmutableBaseExportedChatInvite withUsers(User ... elements) {
        List<User> newValue = ImmutableBaseExportedChatInvite.createUnmodifiableList(false, ImmutableBaseExportedChatInvite.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseExportedChatInvite(this.identifier, this.invite, newValue);
    }

    public final ImmutableBaseExportedChatInvite withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBaseExportedChatInvite.createUnmodifiableList(false, ImmutableBaseExportedChatInvite.createSafeList(elements, true, false));
        return new ImmutableBaseExportedChatInvite(this.identifier, this.invite, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseExportedChatInvite && this.equalTo(0, (ImmutableBaseExportedChatInvite)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseExportedChatInvite another) {
        return this.identifier == another.identifier && this.invite.equals(another.invite) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.invite.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "BaseExportedChatInvite{identifier=" + this.identifier + ", invite=" + this.invite + ", users=" + this.users + "}";
    }

    public static ImmutableBaseExportedChatInvite of(ExportedChatInvite invite) {
        return new ImmutableBaseExportedChatInvite(invite);
    }

    public static ImmutableBaseExportedChatInvite copyOf(BaseExportedChatInvite instance) {
        if (instance instanceof ImmutableBaseExportedChatInvite) {
            return (ImmutableBaseExportedChatInvite)instance;
        }
        return ImmutableBaseExportedChatInvite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_INVITE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private ExportedChatInvite invite;
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(BaseExportedChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(telegram4j.tl.messages.ExportedChatInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            telegram4j.tl.messages.ExportedChatInvite instance;
            long bits = 0L;
            if (object instanceof BaseExportedChatInvite) {
                instance = (BaseExportedChatInvite)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllUsers(instance.users());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.invite(instance.invite());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof telegram4j.tl.messages.ExportedChatInvite) {
                instance = (telegram4j.tl.messages.ExportedChatInvite)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllUsers(instance.users());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.invite(instance.invite());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder invite(ExportedChatInvite invite) {
            this.invite = Objects.requireNonNull(invite, "invite");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableBaseExportedChatInvite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseExportedChatInvite(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("invite");
            }
            return "Cannot build BaseExportedChatInvite, some of required attributes are not set " + attributes;
        }
    }
}

