/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Document;
import telegram4j.tl.StickerPack;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BaseFavedStickers;
import telegram4j.tl.messages.FavedStickers;

public final class ImmutableBaseFavedStickers
implements BaseFavedStickers {
    private final int identifier;
    private final long hash;
    private final List<StickerPack> packs;
    private final List<Document> stickers;

    private ImmutableBaseFavedStickers(long hash) {
        this.hash = hash;
        this.packs = Collections.emptyList();
        this.stickers = Collections.emptyList();
        this.identifier = BaseFavedStickers.super.identifier();
    }

    private ImmutableBaseFavedStickers(Builder builder) {
        this.hash = builder.hash;
        this.packs = ImmutableBaseFavedStickers.createUnmodifiableList(true, builder.packs);
        this.stickers = ImmutableBaseFavedStickers.createUnmodifiableList(true, builder.stickers);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseFavedStickers.super.identifier();
    }

    private ImmutableBaseFavedStickers(int identifier, long hash, List<StickerPack> packs, List<Document> stickers) {
        this.identifier = identifier;
        this.hash = hash;
        this.packs = packs;
        this.stickers = stickers;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public List<StickerPack> packs() {
        return this.packs;
    }

    @Override
    public List<Document> stickers() {
        return this.stickers;
    }

    public final ImmutableBaseFavedStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseFavedStickers(value, this.hash, this.packs, this.stickers);
    }

    public final ImmutableBaseFavedStickers withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseFavedStickers(this.identifier, value, this.packs, this.stickers);
    }

    public final ImmutableBaseFavedStickers withPacks(StickerPack ... elements) {
        List<StickerPack> newValue = ImmutableBaseFavedStickers.createUnmodifiableList(false, ImmutableBaseFavedStickers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseFavedStickers(this.identifier, this.hash, newValue, this.stickers);
    }

    public final ImmutableBaseFavedStickers withPacks(Iterable<? extends StickerPack> elements) {
        if (this.packs == elements) {
            return this;
        }
        List<StickerPack> newValue = ImmutableBaseFavedStickers.createUnmodifiableList(false, ImmutableBaseFavedStickers.createSafeList(elements, true, false));
        return new ImmutableBaseFavedStickers(this.identifier, this.hash, newValue, this.stickers);
    }

    public final ImmutableBaseFavedStickers withStickers(Document ... elements) {
        List<Document> newValue = ImmutableBaseFavedStickers.createUnmodifiableList(false, ImmutableBaseFavedStickers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseFavedStickers(this.identifier, this.hash, this.packs, newValue);
    }

    public final ImmutableBaseFavedStickers withStickers(Iterable<? extends Document> elements) {
        if (this.stickers == elements) {
            return this;
        }
        List<Document> newValue = ImmutableBaseFavedStickers.createUnmodifiableList(false, ImmutableBaseFavedStickers.createSafeList(elements, true, false));
        return new ImmutableBaseFavedStickers(this.identifier, this.hash, this.packs, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseFavedStickers && this.equalTo(0, (ImmutableBaseFavedStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseFavedStickers another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.packs.equals(another.packs) && this.stickers.equals(another.stickers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.packs.hashCode();
        h += (h << 5) + this.stickers.hashCode();
        return h;
    }

    public String toString() {
        return "BaseFavedStickers{identifier=" + this.identifier + ", hash=" + this.hash + ", packs=" + this.packs + ", stickers=" + this.stickers + "}";
    }

    public static ImmutableBaseFavedStickers of(long hash) {
        return new ImmutableBaseFavedStickers(hash);
    }

    public static ImmutableBaseFavedStickers copyOf(BaseFavedStickers instance) {
        if (instance instanceof ImmutableBaseFavedStickers) {
            return (ImmutableBaseFavedStickers)instance;
        }
        return ImmutableBaseFavedStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;
        private List<StickerPack> packs = new ArrayList<StickerPack>();
        private List<Document> stickers = new ArrayList<Document>();

        private Builder() {
        }

        public final Builder from(FavedStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseFavedStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FavedStickers instance;
            long bits = 0L;
            if (object instanceof FavedStickers) {
                instance = (FavedStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseFavedStickers) {
                instance = (BaseFavedStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllStickers(instance.stickers());
                this.addAllPacks(instance.packs());
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPack(StickerPack element) {
            this.packs.add(Objects.requireNonNull(element, "packs element"));
            return this;
        }

        public final Builder addPacks(StickerPack ... elements) {
            for (StickerPack element : elements) {
                this.packs.add(Objects.requireNonNull(element, "packs element"));
            }
            return this;
        }

        public final Builder packs(Iterable<? extends StickerPack> elements) {
            this.packs.clear();
            return this.addAllPacks(elements);
        }

        public final Builder addAllPacks(Iterable<? extends StickerPack> elements) {
            for (StickerPack stickerPack : elements) {
                this.packs.add(Objects.requireNonNull(stickerPack, "packs element"));
            }
            return this;
        }

        public final Builder addSticker(Document element) {
            this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            return this;
        }

        public final Builder addStickers(Document ... elements) {
            for (Document element : elements) {
                this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            }
            return this;
        }

        public final Builder stickers(Iterable<? extends Document> elements) {
            this.stickers.clear();
            return this.addAllStickers(elements);
        }

        public final Builder addAllStickers(Iterable<? extends Document> elements) {
            for (Document document : elements) {
                this.stickers.add(Objects.requireNonNull(document, "stickers element"));
            }
            return this;
        }

        public ImmutableBaseFavedStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseFavedStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseFavedStickers, some of required attributes are not set " + attributes;
        }
    }
}

