/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.StickerSetCovered;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BaseFeaturedStickers;
import telegram4j.tl.messages.FeaturedStickers;

public final class ImmutableBaseFeaturedStickers
implements BaseFeaturedStickers {
    private final int identifier;
    private final int flags;
    private final boolean premium;
    private final long hash;
    private final int count;
    private final List<StickerSetCovered> sets;
    private final List<Long> unread;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBaseFeaturedStickers(long hash, int count) {
        this.hash = hash;
        this.count = count;
        this.sets = Collections.emptyList();
        this.unread = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.premium = this.initShim.premium();
        this.initShim = null;
    }

    private ImmutableBaseFeaturedStickers(Builder builder) {
        this.hash = builder.hash;
        this.count = builder.count;
        this.sets = ImmutableBaseFeaturedStickers.createUnmodifiableList(true, builder.sets);
        this.unread = ImmutableBaseFeaturedStickers.createUnmodifiableList(true, builder.unread);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.premiumIsSet()) {
            this.initShim.premium(builder.premium);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.premium = this.initShim.premium();
        this.initShim = null;
    }

    private ImmutableBaseFeaturedStickers(int identifier, int flags, boolean premium, long hash, int count, List<StickerSetCovered> sets, List<Long> unread) {
        this.identifier = identifier;
        this.flags = flags;
        this.premium = premium;
        this.hash = hash;
        this.count = count;
        this.sets = sets;
        this.unread = unread;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BaseFeaturedStickers.super.identifier();
    }

    private int flagsInitialize() {
        return BaseFeaturedStickers.super.flags();
    }

    private boolean premiumInitialize() {
        return BaseFeaturedStickers.super.premium();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean premium() {
        InitShim shim = this.initShim;
        return shim != null ? shim.premium() : this.premium;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<StickerSetCovered> sets() {
        return this.sets;
    }

    @Override
    public List<Long> unread() {
        return this.unread;
    }

    public final ImmutableBaseFeaturedStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseFeaturedStickers(value, this.flags, this.premium, this.hash, this.count, this.sets, this.unread);
    }

    public final ImmutableBaseFeaturedStickers withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBaseFeaturedStickers(this.identifier, value, this.premium, this.hash, this.count, this.sets, this.unread);
    }

    public final ImmutableBaseFeaturedStickers withPremium(boolean value) {
        if (this.premium == value) {
            return this;
        }
        return new ImmutableBaseFeaturedStickers(this.identifier, this.flags, value, this.hash, this.count, this.sets, this.unread);
    }

    public final ImmutableBaseFeaturedStickers withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseFeaturedStickers(this.identifier, this.flags, this.premium, value, this.count, this.sets, this.unread);
    }

    public final ImmutableBaseFeaturedStickers withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableBaseFeaturedStickers(this.identifier, this.flags, this.premium, this.hash, value, this.sets, this.unread);
    }

    public final ImmutableBaseFeaturedStickers withSets(StickerSetCovered ... elements) {
        List<StickerSetCovered> newValue = ImmutableBaseFeaturedStickers.createUnmodifiableList(false, ImmutableBaseFeaturedStickers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseFeaturedStickers(this.identifier, this.flags, this.premium, this.hash, this.count, newValue, this.unread);
    }

    public final ImmutableBaseFeaturedStickers withSets(Iterable<? extends StickerSetCovered> elements) {
        if (this.sets == elements) {
            return this;
        }
        List<StickerSetCovered> newValue = ImmutableBaseFeaturedStickers.createUnmodifiableList(false, ImmutableBaseFeaturedStickers.createSafeList(elements, true, false));
        return new ImmutableBaseFeaturedStickers(this.identifier, this.flags, this.premium, this.hash, this.count, newValue, this.unread);
    }

    public final ImmutableBaseFeaturedStickers withUnread(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableBaseFeaturedStickers.createUnmodifiableList(false, wrappedList);
        return new ImmutableBaseFeaturedStickers(this.identifier, this.flags, this.premium, this.hash, this.count, this.sets, newValue);
    }

    public final ImmutableBaseFeaturedStickers withUnread(Iterable<Long> elements) {
        if (this.unread == elements) {
            return this;
        }
        List<Long> newValue = ImmutableBaseFeaturedStickers.createUnmodifiableList(false, ImmutableBaseFeaturedStickers.createSafeList(elements, true, false));
        return new ImmutableBaseFeaturedStickers(this.identifier, this.flags, this.premium, this.hash, this.count, this.sets, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseFeaturedStickers && this.equalTo(0, (ImmutableBaseFeaturedStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseFeaturedStickers another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.premium == another.premium && this.hash == another.hash && this.count == another.count && this.sets.equals(another.sets) && this.unread.equals(another.unread);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.premium);
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.count;
        h += (h << 5) + this.sets.hashCode();
        h += (h << 5) + this.unread.hashCode();
        return h;
    }

    public String toString() {
        return "BaseFeaturedStickers{identifier=" + this.identifier + ", flags=" + this.flags + ", premium=" + this.premium + ", hash=" + this.hash + ", count=" + this.count + ", sets=" + this.sets + ", unread=" + this.unread + "}";
    }

    public static ImmutableBaseFeaturedStickers of(long hash, int count) {
        return new ImmutableBaseFeaturedStickers(hash, count);
    }

    public static ImmutableBaseFeaturedStickers copyOf(BaseFeaturedStickers instance) {
        if (instance instanceof ImmutableBaseFeaturedStickers) {
            return (ImmutableBaseFeaturedStickers)instance;
        }
        return ImmutableBaseFeaturedStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_COUNT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PREMIUM = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean premium;
        private long hash;
        private int count;
        private List<StickerSetCovered> sets = new ArrayList<StickerSetCovered>();
        private List<Long> unread = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(FeaturedStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseFeaturedStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FeaturedStickers instance;
            long bits = 0L;
            if (object instanceof FeaturedStickers) {
                instance = (FeaturedStickers)object;
                if ((bits & 2L) == 0L) {
                    this.count(instance.count());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseFeaturedStickers) {
                instance = (BaseFeaturedStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.premium(instance.premium());
                this.addAllSets(instance.sets());
                this.addAllUnread(instance.unread());
                this.flags(instance.flags());
                if ((bits & 2L) == 0L) {
                    this.count(instance.count());
                    bits |= 2L;
                }
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder premium(boolean premium) {
            this.premium = premium;
            this.optBits |= 4L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addSet(StickerSetCovered element) {
            this.sets.add(Objects.requireNonNull(element, "sets element"));
            return this;
        }

        public final Builder addSets(StickerSetCovered ... elements) {
            for (StickerSetCovered element : elements) {
                this.sets.add(Objects.requireNonNull(element, "sets element"));
            }
            return this;
        }

        public final Builder sets(Iterable<? extends StickerSetCovered> elements) {
            this.sets.clear();
            return this.addAllSets(elements);
        }

        public final Builder addAllSets(Iterable<? extends StickerSetCovered> elements) {
            for (StickerSetCovered stickerSetCovered : elements) {
                this.sets.add(Objects.requireNonNull(stickerSetCovered, "sets element"));
            }
            return this;
        }

        public final Builder addUnread(long element) {
            this.unread.add(element);
            return this;
        }

        public final Builder addUnread(long ... elements) {
            for (long element : elements) {
                this.unread.add(element);
            }
            return this;
        }

        public final Builder unread(Iterable<Long> elements) {
            this.unread.clear();
            return this.addAllUnread(elements);
        }

        public final Builder addAllUnread(Iterable<Long> elements) {
            for (Long element : elements) {
                this.unread.add(Objects.requireNonNull(element, "unread element"));
            }
            return this;
        }

        public ImmutableBaseFeaturedStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseFeaturedStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean premiumIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build BaseFeaturedStickers, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte premiumBuildStage = 0;
        private boolean premium;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBaseFeaturedStickers.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBaseFeaturedStickers.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean premium() {
            if (this.premiumBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.premiumBuildStage == 0) {
                this.premiumBuildStage = (byte)-1;
                this.premium = ImmutableBaseFeaturedStickers.this.premiumInitialize();
                this.premiumBuildStage = 1;
            }
            return this.premium;
        }

        void premium(boolean premium) {
            this.premium = premium;
            this.premiumBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.premiumBuildStage == -1) {
                attributes.add("premium");
            }
            return "Cannot build BaseFeaturedStickers, attribute initializers form cycle " + attributes;
        }
    }
}

