/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.StickerSetCovered;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BaseFoundStickerSets;
import telegram4j.tl.messages.FoundStickerSets;

public final class ImmutableBaseFoundStickerSets
implements BaseFoundStickerSets {
    private final int identifier;
    private final long hash;
    private final List<StickerSetCovered> sets;

    private ImmutableBaseFoundStickerSets(long hash) {
        this.hash = hash;
        this.sets = Collections.emptyList();
        this.identifier = BaseFoundStickerSets.super.identifier();
    }

    private ImmutableBaseFoundStickerSets(Builder builder) {
        this.hash = builder.hash;
        this.sets = ImmutableBaseFoundStickerSets.createUnmodifiableList(true, builder.sets);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseFoundStickerSets.super.identifier();
    }

    private ImmutableBaseFoundStickerSets(int identifier, long hash, List<StickerSetCovered> sets) {
        this.identifier = identifier;
        this.hash = hash;
        this.sets = sets;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public List<StickerSetCovered> sets() {
        return this.sets;
    }

    public final ImmutableBaseFoundStickerSets withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseFoundStickerSets(value, this.hash, this.sets);
    }

    public final ImmutableBaseFoundStickerSets withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseFoundStickerSets(this.identifier, value, this.sets);
    }

    public final ImmutableBaseFoundStickerSets withSets(StickerSetCovered ... elements) {
        List<StickerSetCovered> newValue = ImmutableBaseFoundStickerSets.createUnmodifiableList(false, ImmutableBaseFoundStickerSets.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseFoundStickerSets(this.identifier, this.hash, newValue);
    }

    public final ImmutableBaseFoundStickerSets withSets(Iterable<? extends StickerSetCovered> elements) {
        if (this.sets == elements) {
            return this;
        }
        List<StickerSetCovered> newValue = ImmutableBaseFoundStickerSets.createUnmodifiableList(false, ImmutableBaseFoundStickerSets.createSafeList(elements, true, false));
        return new ImmutableBaseFoundStickerSets(this.identifier, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseFoundStickerSets && this.equalTo(0, (ImmutableBaseFoundStickerSets)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseFoundStickerSets another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.sets.equals(another.sets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.sets.hashCode();
        return h;
    }

    public String toString() {
        return "BaseFoundStickerSets{identifier=" + this.identifier + ", hash=" + this.hash + ", sets=" + this.sets + "}";
    }

    public static ImmutableBaseFoundStickerSets of(long hash) {
        return new ImmutableBaseFoundStickerSets(hash);
    }

    public static ImmutableBaseFoundStickerSets copyOf(BaseFoundStickerSets instance) {
        if (instance instanceof ImmutableBaseFoundStickerSets) {
            return (ImmutableBaseFoundStickerSets)instance;
        }
        return ImmutableBaseFoundStickerSets.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;
        private List<StickerSetCovered> sets = new ArrayList<StickerSetCovered>();

        private Builder() {
        }

        public final Builder from(FoundStickerSets instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseFoundStickerSets instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FoundStickerSets instance;
            long bits = 0L;
            if (object instanceof FoundStickerSets) {
                instance = (FoundStickerSets)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseFoundStickerSets) {
                instance = (BaseFoundStickerSets)object;
                this.addAllSets(instance.sets());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSet(StickerSetCovered element) {
            this.sets.add(Objects.requireNonNull(element, "sets element"));
            return this;
        }

        public final Builder addSets(StickerSetCovered ... elements) {
            for (StickerSetCovered element : elements) {
                this.sets.add(Objects.requireNonNull(element, "sets element"));
            }
            return this;
        }

        public final Builder sets(Iterable<? extends StickerSetCovered> elements) {
            this.sets.clear();
            return this.addAllSets(elements);
        }

        public final Builder addAllSets(Iterable<? extends StickerSetCovered> elements) {
            for (StickerSetCovered stickerSetCovered : elements) {
                this.sets.add(Objects.requireNonNull(stickerSetCovered, "sets element"));
            }
            return this;
        }

        public ImmutableBaseFoundStickerSets build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseFoundStickerSets(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseFoundStickerSets, some of required attributes are not set " + attributes;
        }
    }
}

