/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Document;
import telegram4j.tl.StickerPack;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BaseRecentStickers;
import telegram4j.tl.messages.RecentStickers;

public final class ImmutableBaseRecentStickers
implements BaseRecentStickers {
    private final int identifier;
    private final long hash;
    private final List<StickerPack> packs;
    private final List<Document> stickers;
    private final List<Integer> dates;

    private ImmutableBaseRecentStickers(long hash) {
        this.hash = hash;
        this.packs = Collections.emptyList();
        this.stickers = Collections.emptyList();
        this.dates = Collections.emptyList();
        this.identifier = BaseRecentStickers.super.identifier();
    }

    private ImmutableBaseRecentStickers(Builder builder) {
        this.hash = builder.hash;
        this.packs = ImmutableBaseRecentStickers.createUnmodifiableList(true, builder.packs);
        this.stickers = ImmutableBaseRecentStickers.createUnmodifiableList(true, builder.stickers);
        this.dates = ImmutableBaseRecentStickers.createUnmodifiableList(true, builder.dates);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseRecentStickers.super.identifier();
    }

    private ImmutableBaseRecentStickers(int identifier, long hash, List<StickerPack> packs, List<Document> stickers, List<Integer> dates) {
        this.identifier = identifier;
        this.hash = hash;
        this.packs = packs;
        this.stickers = stickers;
        this.dates = dates;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public List<StickerPack> packs() {
        return this.packs;
    }

    @Override
    public List<Document> stickers() {
        return this.stickers;
    }

    @Override
    public List<Integer> dates() {
        return this.dates;
    }

    public final ImmutableBaseRecentStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseRecentStickers(value, this.hash, this.packs, this.stickers, this.dates);
    }

    public final ImmutableBaseRecentStickers withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseRecentStickers(this.identifier, value, this.packs, this.stickers, this.dates);
    }

    public final ImmutableBaseRecentStickers withPacks(StickerPack ... elements) {
        List<StickerPack> newValue = ImmutableBaseRecentStickers.createUnmodifiableList(false, ImmutableBaseRecentStickers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseRecentStickers(this.identifier, this.hash, newValue, this.stickers, this.dates);
    }

    public final ImmutableBaseRecentStickers withPacks(Iterable<? extends StickerPack> elements) {
        if (this.packs == elements) {
            return this;
        }
        List<StickerPack> newValue = ImmutableBaseRecentStickers.createUnmodifiableList(false, ImmutableBaseRecentStickers.createSafeList(elements, true, false));
        return new ImmutableBaseRecentStickers(this.identifier, this.hash, newValue, this.stickers, this.dates);
    }

    public final ImmutableBaseRecentStickers withStickers(Document ... elements) {
        List<Document> newValue = ImmutableBaseRecentStickers.createUnmodifiableList(false, ImmutableBaseRecentStickers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseRecentStickers(this.identifier, this.hash, this.packs, newValue, this.dates);
    }

    public final ImmutableBaseRecentStickers withStickers(Iterable<? extends Document> elements) {
        if (this.stickers == elements) {
            return this;
        }
        List<Document> newValue = ImmutableBaseRecentStickers.createUnmodifiableList(false, ImmutableBaseRecentStickers.createSafeList(elements, true, false));
        return new ImmutableBaseRecentStickers(this.identifier, this.hash, this.packs, newValue, this.dates);
    }

    public final ImmutableBaseRecentStickers withDates(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableBaseRecentStickers.createUnmodifiableList(false, wrappedList);
        return new ImmutableBaseRecentStickers(this.identifier, this.hash, this.packs, this.stickers, newValue);
    }

    public final ImmutableBaseRecentStickers withDates(Iterable<Integer> elements) {
        if (this.dates == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableBaseRecentStickers.createUnmodifiableList(false, ImmutableBaseRecentStickers.createSafeList(elements, true, false));
        return new ImmutableBaseRecentStickers(this.identifier, this.hash, this.packs, this.stickers, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseRecentStickers && this.equalTo(0, (ImmutableBaseRecentStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseRecentStickers another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.packs.equals(another.packs) && this.stickers.equals(another.stickers) && this.dates.equals(another.dates);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.packs.hashCode();
        h += (h << 5) + this.stickers.hashCode();
        h += (h << 5) + this.dates.hashCode();
        return h;
    }

    public String toString() {
        return "BaseRecentStickers{identifier=" + this.identifier + ", hash=" + this.hash + ", packs=" + this.packs + ", stickers=" + this.stickers + ", dates=" + this.dates + "}";
    }

    public static ImmutableBaseRecentStickers of(long hash) {
        return new ImmutableBaseRecentStickers(hash);
    }

    public static ImmutableBaseRecentStickers copyOf(BaseRecentStickers instance) {
        if (instance instanceof ImmutableBaseRecentStickers) {
            return (ImmutableBaseRecentStickers)instance;
        }
        return ImmutableBaseRecentStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;
        private List<StickerPack> packs = new ArrayList<StickerPack>();
        private List<Document> stickers = new ArrayList<Document>();
        private List<Integer> dates = new ArrayList<Integer>();

        private Builder() {
        }

        public final Builder from(BaseRecentStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecentStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RecentStickers instance;
            long bits = 0L;
            if (object instanceof BaseRecentStickers) {
                instance = (BaseRecentStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllStickers(instance.stickers());
                this.addAllDates(instance.dates());
                this.addAllPacks(instance.packs());
                this.hash(instance.hash());
            }
            if (object instanceof RecentStickers) {
                instance = (RecentStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPack(StickerPack element) {
            this.packs.add(Objects.requireNonNull(element, "packs element"));
            return this;
        }

        public final Builder addPacks(StickerPack ... elements) {
            for (StickerPack element : elements) {
                this.packs.add(Objects.requireNonNull(element, "packs element"));
            }
            return this;
        }

        public final Builder packs(Iterable<? extends StickerPack> elements) {
            this.packs.clear();
            return this.addAllPacks(elements);
        }

        public final Builder addAllPacks(Iterable<? extends StickerPack> elements) {
            for (StickerPack stickerPack : elements) {
                this.packs.add(Objects.requireNonNull(stickerPack, "packs element"));
            }
            return this;
        }

        public final Builder addSticker(Document element) {
            this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            return this;
        }

        public final Builder addStickers(Document ... elements) {
            for (Document element : elements) {
                this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            }
            return this;
        }

        public final Builder stickers(Iterable<? extends Document> elements) {
            this.stickers.clear();
            return this.addAllStickers(elements);
        }

        public final Builder addAllStickers(Iterable<? extends Document> elements) {
            for (Document document : elements) {
                this.stickers.add(Objects.requireNonNull(document, "stickers element"));
            }
            return this;
        }

        public final Builder addDate(int element) {
            this.dates.add(element);
            return this;
        }

        public final Builder addDates(int ... elements) {
            for (int element : elements) {
                this.dates.add(element);
            }
            return this;
        }

        public final Builder dates(Iterable<Integer> elements) {
            this.dates.clear();
            return this.addAllDates(elements);
        }

        public final Builder addAllDates(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.dates.add(Objects.requireNonNull(element, "dates element"));
            }
            return this;
        }

        public ImmutableBaseRecentStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseRecentStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseRecentStickers, some of required attributes are not set " + attributes;
        }
    }
}

