/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Document;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BaseSavedGifs;
import telegram4j.tl.messages.SavedGifs;

public final class ImmutableBaseSavedGifs
implements BaseSavedGifs {
    private final int identifier;
    private final long hash;
    private final List<Document> gifs;

    private ImmutableBaseSavedGifs(long hash) {
        this.hash = hash;
        this.gifs = Collections.emptyList();
        this.identifier = BaseSavedGifs.super.identifier();
    }

    private ImmutableBaseSavedGifs(Builder builder) {
        this.hash = builder.hash;
        this.gifs = ImmutableBaseSavedGifs.createUnmodifiableList(true, builder.gifs);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseSavedGifs.super.identifier();
    }

    private ImmutableBaseSavedGifs(int identifier, long hash, List<Document> gifs) {
        this.identifier = identifier;
        this.hash = hash;
        this.gifs = gifs;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public List<Document> gifs() {
        return this.gifs;
    }

    public final ImmutableBaseSavedGifs withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseSavedGifs(value, this.hash, this.gifs);
    }

    public final ImmutableBaseSavedGifs withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseSavedGifs(this.identifier, value, this.gifs);
    }

    public final ImmutableBaseSavedGifs withGifs(Document ... elements) {
        List<Document> newValue = ImmutableBaseSavedGifs.createUnmodifiableList(false, ImmutableBaseSavedGifs.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseSavedGifs(this.identifier, this.hash, newValue);
    }

    public final ImmutableBaseSavedGifs withGifs(Iterable<? extends Document> elements) {
        if (this.gifs == elements) {
            return this;
        }
        List<Document> newValue = ImmutableBaseSavedGifs.createUnmodifiableList(false, ImmutableBaseSavedGifs.createSafeList(elements, true, false));
        return new ImmutableBaseSavedGifs(this.identifier, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseSavedGifs && this.equalTo(0, (ImmutableBaseSavedGifs)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseSavedGifs another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.gifs.equals(another.gifs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.gifs.hashCode();
        return h;
    }

    public String toString() {
        return "BaseSavedGifs{identifier=" + this.identifier + ", hash=" + this.hash + ", gifs=" + this.gifs + "}";
    }

    public static ImmutableBaseSavedGifs of(long hash) {
        return new ImmutableBaseSavedGifs(hash);
    }

    public static ImmutableBaseSavedGifs copyOf(BaseSavedGifs instance) {
        if (instance instanceof ImmutableBaseSavedGifs) {
            return (ImmutableBaseSavedGifs)instance;
        }
        return ImmutableBaseSavedGifs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;
        private List<Document> gifs = new ArrayList<Document>();

        private Builder() {
        }

        public final Builder from(BaseSavedGifs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SavedGifs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SavedGifs instance;
            long bits = 0L;
            if (object instanceof BaseSavedGifs) {
                instance = (BaseSavedGifs)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hash(instance.hash());
                this.addAllGifs(instance.gifs());
            }
            if (object instanceof SavedGifs) {
                instance = (SavedGifs)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addGif(Document element) {
            this.gifs.add(Objects.requireNonNull(element, "gifs element"));
            return this;
        }

        public final Builder addGifs(Document ... elements) {
            for (Document element : elements) {
                this.gifs.add(Objects.requireNonNull(element, "gifs element"));
            }
            return this;
        }

        public final Builder gifs(Iterable<? extends Document> elements) {
            this.gifs.clear();
            return this.addAllGifs(elements);
        }

        public final Builder addAllGifs(Iterable<? extends Document> elements) {
            for (Document document : elements) {
                this.gifs.add(Objects.requireNonNull(document, "gifs element"));
            }
            return this;
        }

        public ImmutableBaseSavedGifs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseSavedGifs(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseSavedGifs, some of required attributes are not set " + attributes;
        }
    }
}

