/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BaseSentEncryptedMessage;
import telegram4j.tl.messages.SentEncryptedMessage;

public final class ImmutableBaseSentEncryptedMessage
implements BaseSentEncryptedMessage {
    private final int identifier;
    private final int date;

    private ImmutableBaseSentEncryptedMessage(int date) {
        this.date = date;
        this.identifier = BaseSentEncryptedMessage.super.identifier();
    }

    private ImmutableBaseSentEncryptedMessage(Builder builder) {
        this.date = builder.date;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseSentEncryptedMessage.super.identifier();
    }

    private ImmutableBaseSentEncryptedMessage(int identifier, int date) {
        this.identifier = identifier;
        this.date = date;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int date() {
        return this.date;
    }

    public final ImmutableBaseSentEncryptedMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseSentEncryptedMessage(value, this.date);
    }

    public final ImmutableBaseSentEncryptedMessage withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableBaseSentEncryptedMessage(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseSentEncryptedMessage && this.equalTo(0, (ImmutableBaseSentEncryptedMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseSentEncryptedMessage another) {
        return this.identifier == another.identifier && this.date == another.date;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.date;
        return h;
    }

    public String toString() {
        return "BaseSentEncryptedMessage{identifier=" + this.identifier + ", date=" + this.date + "}";
    }

    public static ImmutableBaseSentEncryptedMessage of(int date) {
        return new ImmutableBaseSentEncryptedMessage(date);
    }

    public static ImmutableBaseSentEncryptedMessage copyOf(BaseSentEncryptedMessage instance) {
        if (instance instanceof ImmutableBaseSentEncryptedMessage) {
            return (ImmutableBaseSentEncryptedMessage)instance;
        }
        return ImmutableBaseSentEncryptedMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int date;

        private Builder() {
        }

        public final Builder from(BaseSentEncryptedMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SentEncryptedMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SentEncryptedMessage instance;
            long bits = 0L;
            if (object instanceof BaseSentEncryptedMessage) {
                instance = (BaseSentEncryptedMessage)object;
                if ((bits & 1L) == 0L) {
                    this.date(instance.date());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
            if (object instanceof SentEncryptedMessage) {
                instance = (SentEncryptedMessage)object;
                if ((bits & 1L) == 0L) {
                    this.date(instance.date());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBaseSentEncryptedMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseSentEncryptedMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            return "Cannot build BaseSentEncryptedMessage, some of required attributes are not set " + attributes;
        }
    }
}

