/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Document;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BaseStickers;
import telegram4j.tl.messages.Stickers;

public final class ImmutableBaseStickers
implements BaseStickers {
    private final int identifier;
    private final long hash;
    private final List<Document> stickers;

    private ImmutableBaseStickers(long hash) {
        this.hash = hash;
        this.stickers = Collections.emptyList();
        this.identifier = BaseStickers.super.identifier();
    }

    private ImmutableBaseStickers(Builder builder) {
        this.hash = builder.hash;
        this.stickers = ImmutableBaseStickers.createUnmodifiableList(true, builder.stickers);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseStickers.super.identifier();
    }

    private ImmutableBaseStickers(int identifier, long hash, List<Document> stickers) {
        this.identifier = identifier;
        this.hash = hash;
        this.stickers = stickers;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    public List<Document> stickers() {
        return this.stickers;
    }

    public final ImmutableBaseStickers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseStickers(value, this.hash, this.stickers);
    }

    public final ImmutableBaseStickers withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableBaseStickers(this.identifier, value, this.stickers);
    }

    public final ImmutableBaseStickers withStickers(Document ... elements) {
        List<Document> newValue = ImmutableBaseStickers.createUnmodifiableList(false, ImmutableBaseStickers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBaseStickers(this.identifier, this.hash, newValue);
    }

    public final ImmutableBaseStickers withStickers(Iterable<? extends Document> elements) {
        if (this.stickers == elements) {
            return this;
        }
        List<Document> newValue = ImmutableBaseStickers.createUnmodifiableList(false, ImmutableBaseStickers.createSafeList(elements, true, false));
        return new ImmutableBaseStickers(this.identifier, this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseStickers && this.equalTo(0, (ImmutableBaseStickers)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseStickers another) {
        return this.identifier == another.identifier && this.hash == another.hash && this.stickers.equals(another.stickers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + this.stickers.hashCode();
        return h;
    }

    public String toString() {
        return "BaseStickers{identifier=" + this.identifier + ", hash=" + this.hash + ", stickers=" + this.stickers + "}";
    }

    public static ImmutableBaseStickers of(long hash) {
        return new ImmutableBaseStickers(hash);
    }

    public static ImmutableBaseStickers copyOf(BaseStickers instance) {
        if (instance instanceof ImmutableBaseStickers) {
            return (ImmutableBaseStickers)instance;
        }
        return ImmutableBaseStickers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private long hash;
        private List<Document> stickers = new ArrayList<Document>();

        private Builder() {
        }

        public final Builder from(BaseStickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Stickers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Stickers instance;
            long bits = 0L;
            if (object instanceof BaseStickers) {
                instance = (BaseStickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllStickers(instance.stickers());
                this.hash(instance.hash());
            }
            if (object instanceof Stickers) {
                instance = (Stickers)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSticker(Document element) {
            this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            return this;
        }

        public final Builder addStickers(Document ... elements) {
            for (Document element : elements) {
                this.stickers.add(Objects.requireNonNull(element, "stickers element"));
            }
            return this;
        }

        public final Builder stickers(Iterable<? extends Document> elements) {
            this.stickers.clear();
            return this.addAllStickers(elements);
        }

        public final Builder addAllStickers(Iterable<? extends Document> elements) {
            for (Document document : elements) {
                this.stickers.add(Objects.requireNonNull(document, "stickers element"));
            }
            return this;
        }

        public ImmutableBaseStickers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseStickers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build BaseStickers, some of required attributes are not set " + attributes;
        }
    }
}

