/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BotCallbackAnswer;

public final class ImmutableBotCallbackAnswer
implements BotCallbackAnswer {
    private final int identifier;
    private final int flags;
    private final boolean alert;
    private final boolean hasUrl;
    private final boolean nativeUi;
    @Nullable
    private final String message;
    @Nullable
    private final String url;
    private final int cacheTime;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBotCallbackAnswer(int cacheTime) {
        this.cacheTime = cacheTime;
        this.message = null;
        this.url = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.alert = this.initShim.alert();
        this.hasUrl = this.initShim.hasUrl();
        this.nativeUi = this.initShim.nativeUi();
        this.initShim = null;
    }

    private ImmutableBotCallbackAnswer(Builder builder) {
        this.message = builder.message;
        this.url = builder.url;
        this.cacheTime = builder.cacheTime;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.alertIsSet()) {
            this.initShim.alert(builder.alert);
        }
        if (builder.hasUrlIsSet()) {
            this.initShim.hasUrl(builder.hasUrl);
        }
        if (builder.nativeUiIsSet()) {
            this.initShim.nativeUi(builder.nativeUi);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.alert = this.initShim.alert();
        this.hasUrl = this.initShim.hasUrl();
        this.nativeUi = this.initShim.nativeUi();
        this.initShim = null;
    }

    private ImmutableBotCallbackAnswer(int identifier, int flags, boolean alert, boolean hasUrl, boolean nativeUi, @Nullable String message, @Nullable String url, int cacheTime) {
        this.identifier = identifier;
        this.flags = flags;
        this.alert = alert;
        this.hasUrl = hasUrl;
        this.nativeUi = nativeUi;
        this.message = message;
        this.url = url;
        this.cacheTime = cacheTime;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BotCallbackAnswer.super.identifier();
    }

    private int flagsInitialize() {
        return BotCallbackAnswer.super.flags();
    }

    private boolean alertInitialize() {
        return BotCallbackAnswer.super.alert();
    }

    private boolean hasUrlInitialize() {
        return BotCallbackAnswer.super.hasUrl();
    }

    private boolean nativeUiInitialize() {
        return BotCallbackAnswer.super.nativeUi();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean alert() {
        InitShim shim = this.initShim;
        return shim != null ? shim.alert() : this.alert;
    }

    @Override
    public boolean hasUrl() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasUrl() : this.hasUrl;
    }

    @Override
    public boolean nativeUi() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nativeUi() : this.nativeUi;
    }

    @Override
    @Nullable
    public String message() {
        return this.message;
    }

    @Override
    @Nullable
    public String url() {
        return this.url;
    }

    @Override
    public int cacheTime() {
        return this.cacheTime;
    }

    public final ImmutableBotCallbackAnswer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBotCallbackAnswer(value, this.flags, this.alert, this.hasUrl, this.nativeUi, this.message, this.url, this.cacheTime);
    }

    public final ImmutableBotCallbackAnswer withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBotCallbackAnswer(this.identifier, value, this.alert, this.hasUrl, this.nativeUi, this.message, this.url, this.cacheTime);
    }

    public final ImmutableBotCallbackAnswer withAlert(boolean value) {
        if (this.alert == value) {
            return this;
        }
        return new ImmutableBotCallbackAnswer(this.identifier, this.flags, value, this.hasUrl, this.nativeUi, this.message, this.url, this.cacheTime);
    }

    public final ImmutableBotCallbackAnswer withHasUrl(boolean value) {
        if (this.hasUrl == value) {
            return this;
        }
        return new ImmutableBotCallbackAnswer(this.identifier, this.flags, this.alert, value, this.nativeUi, this.message, this.url, this.cacheTime);
    }

    public final ImmutableBotCallbackAnswer withNativeUi(boolean value) {
        if (this.nativeUi == value) {
            return this;
        }
        return new ImmutableBotCallbackAnswer(this.identifier, this.flags, this.alert, this.hasUrl, value, this.message, this.url, this.cacheTime);
    }

    public final ImmutableBotCallbackAnswer withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableBotCallbackAnswer(this.identifier, this.flags, this.alert, this.hasUrl, this.nativeUi, value, this.url, this.cacheTime);
    }

    public final ImmutableBotCallbackAnswer withUrl(@Nullable String value) {
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new ImmutableBotCallbackAnswer(this.identifier, this.flags, this.alert, this.hasUrl, this.nativeUi, this.message, value, this.cacheTime);
    }

    public final ImmutableBotCallbackAnswer withCacheTime(int value) {
        if (this.cacheTime == value) {
            return this;
        }
        return new ImmutableBotCallbackAnswer(this.identifier, this.flags, this.alert, this.hasUrl, this.nativeUi, this.message, this.url, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBotCallbackAnswer && this.equalTo(0, (ImmutableBotCallbackAnswer)another);
    }

    private boolean equalTo(int synthetic, ImmutableBotCallbackAnswer another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.alert == another.alert && this.hasUrl == another.hasUrl && this.nativeUi == another.nativeUi && Objects.equals(this.message, another.message) && Objects.equals(this.url, another.url) && this.cacheTime == another.cacheTime;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.alert);
        h += (h << 5) + Boolean.hashCode(this.hasUrl);
        h += (h << 5) + Boolean.hashCode(this.nativeUi);
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + this.cacheTime;
        return h;
    }

    public String toString() {
        return "BotCallbackAnswer{identifier=" + this.identifier + ", flags=" + this.flags + ", alert=" + this.alert + ", hasUrl=" + this.hasUrl + ", nativeUi=" + this.nativeUi + ", message=" + this.message + ", url=" + this.url + ", cacheTime=" + this.cacheTime + "}";
    }

    public static ImmutableBotCallbackAnswer of(int cacheTime) {
        return new ImmutableBotCallbackAnswer(cacheTime);
    }

    public static ImmutableBotCallbackAnswer copyOf(BotCallbackAnswer instance) {
        if (instance instanceof ImmutableBotCallbackAnswer) {
            return (ImmutableBotCallbackAnswer)instance;
        }
        return ImmutableBotCallbackAnswer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CACHE_TIME = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_ALERT = 4L;
        private static final long OPT_BIT_HAS_URL = 8L;
        private static final long OPT_BIT_NATIVE_UI = 16L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean alert;
        private boolean hasUrl;
        private boolean nativeUi;
        private String message;
        private String url;
        private int cacheTime;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BotCallbackAnswer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BotCallbackAnswer) {
                String urlValue;
                instance = (BotCallbackAnswer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.hasUrl(instance.hasUrl());
                this.alert(instance.alert());
                this.nativeUi(instance.nativeUi());
                this.flags(instance.flags());
                String messageValue = instance.message();
                if (messageValue != null) {
                    this.message(messageValue);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
                this.cacheTime(instance.cacheTime());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder alert(boolean alert) {
            this.alert = alert;
            this.optBits |= 4L;
            return this;
        }

        public final Builder hasUrl(boolean hasUrl) {
            this.hasUrl = hasUrl;
            this.optBits |= 8L;
            return this;
        }

        public final Builder nativeUi(boolean nativeUi) {
            this.nativeUi = nativeUi;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        public final Builder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder cacheTime(int cacheTime) {
            this.cacheTime = cacheTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBotCallbackAnswer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBotCallbackAnswer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean alertIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean hasUrlIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean nativeUiIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("cacheTime");
            }
            return "Cannot build BotCallbackAnswer, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte alertBuildStage = 0;
        private boolean alert;
        private byte hasUrlBuildStage = 0;
        private boolean hasUrl;
        private byte nativeUiBuildStage = 0;
        private boolean nativeUi;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBotCallbackAnswer.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBotCallbackAnswer.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean alert() {
            if (this.alertBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.alertBuildStage == 0) {
                this.alertBuildStage = (byte)-1;
                this.alert = ImmutableBotCallbackAnswer.this.alertInitialize();
                this.alertBuildStage = 1;
            }
            return this.alert;
        }

        void alert(boolean alert) {
            this.alert = alert;
            this.alertBuildStage = 1;
        }

        boolean hasUrl() {
            if (this.hasUrlBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasUrlBuildStage == 0) {
                this.hasUrlBuildStage = (byte)-1;
                this.hasUrl = ImmutableBotCallbackAnswer.this.hasUrlInitialize();
                this.hasUrlBuildStage = 1;
            }
            return this.hasUrl;
        }

        void hasUrl(boolean hasUrl) {
            this.hasUrl = hasUrl;
            this.hasUrlBuildStage = 1;
        }

        boolean nativeUi() {
            if (this.nativeUiBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nativeUiBuildStage == 0) {
                this.nativeUiBuildStage = (byte)-1;
                this.nativeUi = ImmutableBotCallbackAnswer.this.nativeUiInitialize();
                this.nativeUiBuildStage = 1;
            }
            return this.nativeUi;
        }

        void nativeUi(boolean nativeUi) {
            this.nativeUi = nativeUi;
            this.nativeUiBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.alertBuildStage == -1) {
                attributes.add("alert");
            }
            if (this.hasUrlBuildStage == -1) {
                attributes.add("hasUrl");
            }
            if (this.nativeUiBuildStage == -1) {
                attributes.add("nativeUi");
            }
            return "Cannot build BotCallbackAnswer, attribute initializers form cycle " + attributes;
        }
    }
}

