/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.BotInlineResult;
import telegram4j.tl.InlineBotSwitchPM;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.BotResults;

public final class ImmutableBotResults
implements BotResults {
    private final int identifier;
    private final int flags;
    private final boolean gallery;
    private final long queryId;
    @Nullable
    private final String nextOffset;
    @Nullable
    private final InlineBotSwitchPM switchPm;
    private final List<BotInlineResult> results;
    private final int cacheTime;
    private final List<User> users;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBotResults(long queryId, int cacheTime) {
        this.queryId = queryId;
        this.cacheTime = cacheTime;
        this.nextOffset = null;
        this.switchPm = null;
        this.results = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.gallery = this.initShim.gallery();
        this.initShim = null;
    }

    private ImmutableBotResults(Builder builder) {
        this.queryId = builder.queryId;
        this.nextOffset = builder.nextOffset;
        this.switchPm = builder.switchPm;
        this.results = ImmutableBotResults.createUnmodifiableList(true, builder.results);
        this.cacheTime = builder.cacheTime;
        this.users = ImmutableBotResults.createUnmodifiableList(true, builder.users);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.galleryIsSet()) {
            this.initShim.gallery(builder.gallery);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.gallery = this.initShim.gallery();
        this.initShim = null;
    }

    private ImmutableBotResults(int identifier, int flags, boolean gallery, long queryId, @Nullable String nextOffset, @Nullable InlineBotSwitchPM switchPm, List<BotInlineResult> results, int cacheTime, List<User> users) {
        this.identifier = identifier;
        this.flags = flags;
        this.gallery = gallery;
        this.queryId = queryId;
        this.nextOffset = nextOffset;
        this.switchPm = switchPm;
        this.results = results;
        this.cacheTime = cacheTime;
        this.users = users;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return BotResults.super.identifier();
    }

    private int flagsInitialize() {
        return BotResults.super.flags();
    }

    private boolean galleryInitialize() {
        return BotResults.super.gallery();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean gallery() {
        InitShim shim = this.initShim;
        return shim != null ? shim.gallery() : this.gallery;
    }

    @Override
    public long queryId() {
        return this.queryId;
    }

    @Override
    @Nullable
    public String nextOffset() {
        return this.nextOffset;
    }

    @Override
    @Nullable
    public InlineBotSwitchPM switchPm() {
        return this.switchPm;
    }

    @Override
    public List<BotInlineResult> results() {
        return this.results;
    }

    @Override
    public int cacheTime() {
        return this.cacheTime;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableBotResults withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBotResults(value, this.flags, this.gallery, this.queryId, this.nextOffset, this.switchPm, this.results, this.cacheTime, this.users);
    }

    public final ImmutableBotResults withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableBotResults(this.identifier, value, this.gallery, this.queryId, this.nextOffset, this.switchPm, this.results, this.cacheTime, this.users);
    }

    public final ImmutableBotResults withGallery(boolean value) {
        if (this.gallery == value) {
            return this;
        }
        return new ImmutableBotResults(this.identifier, this.flags, value, this.queryId, this.nextOffset, this.switchPm, this.results, this.cacheTime, this.users);
    }

    public final ImmutableBotResults withQueryId(long value) {
        if (this.queryId == value) {
            return this;
        }
        return new ImmutableBotResults(this.identifier, this.flags, this.gallery, value, this.nextOffset, this.switchPm, this.results, this.cacheTime, this.users);
    }

    public final ImmutableBotResults withNextOffset(@Nullable String value) {
        if (Objects.equals(this.nextOffset, value)) {
            return this;
        }
        return new ImmutableBotResults(this.identifier, this.flags, this.gallery, this.queryId, value, this.switchPm, this.results, this.cacheTime, this.users);
    }

    public final ImmutableBotResults withSwitchPm(@Nullable InlineBotSwitchPM value) {
        if (this.switchPm == value) {
            return this;
        }
        return new ImmutableBotResults(this.identifier, this.flags, this.gallery, this.queryId, this.nextOffset, value, this.results, this.cacheTime, this.users);
    }

    public final ImmutableBotResults withResults(BotInlineResult ... elements) {
        List<BotInlineResult> newValue = ImmutableBotResults.createUnmodifiableList(false, ImmutableBotResults.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBotResults(this.identifier, this.flags, this.gallery, this.queryId, this.nextOffset, this.switchPm, newValue, this.cacheTime, this.users);
    }

    public final ImmutableBotResults withResults(Iterable<? extends BotInlineResult> elements) {
        if (this.results == elements) {
            return this;
        }
        List<BotInlineResult> newValue = ImmutableBotResults.createUnmodifiableList(false, ImmutableBotResults.createSafeList(elements, true, false));
        return new ImmutableBotResults(this.identifier, this.flags, this.gallery, this.queryId, this.nextOffset, this.switchPm, newValue, this.cacheTime, this.users);
    }

    public final ImmutableBotResults withCacheTime(int value) {
        if (this.cacheTime == value) {
            return this;
        }
        return new ImmutableBotResults(this.identifier, this.flags, this.gallery, this.queryId, this.nextOffset, this.switchPm, this.results, value, this.users);
    }

    public final ImmutableBotResults withUsers(User ... elements) {
        List<User> newValue = ImmutableBotResults.createUnmodifiableList(false, ImmutableBotResults.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBotResults(this.identifier, this.flags, this.gallery, this.queryId, this.nextOffset, this.switchPm, this.results, this.cacheTime, newValue);
    }

    public final ImmutableBotResults withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableBotResults.createUnmodifiableList(false, ImmutableBotResults.createSafeList(elements, true, false));
        return new ImmutableBotResults(this.identifier, this.flags, this.gallery, this.queryId, this.nextOffset, this.switchPm, this.results, this.cacheTime, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBotResults && this.equalTo(0, (ImmutableBotResults)another);
    }

    private boolean equalTo(int synthetic, ImmutableBotResults another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.gallery == another.gallery && this.queryId == another.queryId && Objects.equals(this.nextOffset, another.nextOffset) && Objects.equals(this.switchPm, another.switchPm) && this.results.equals(another.results) && this.cacheTime == another.cacheTime && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.gallery);
        h += (h << 5) + Long.hashCode(this.queryId);
        h += (h << 5) + Objects.hashCode(this.nextOffset);
        h += (h << 5) + Objects.hashCode(this.switchPm);
        h += (h << 5) + this.results.hashCode();
        h += (h << 5) + this.cacheTime;
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "BotResults{identifier=" + this.identifier + ", flags=" + this.flags + ", gallery=" + this.gallery + ", queryId=" + this.queryId + ", nextOffset=" + this.nextOffset + ", switchPm=" + this.switchPm + ", results=" + this.results + ", cacheTime=" + this.cacheTime + ", users=" + this.users + "}";
    }

    public static ImmutableBotResults of(long queryId, int cacheTime) {
        return new ImmutableBotResults(queryId, cacheTime);
    }

    public static ImmutableBotResults copyOf(BotResults instance) {
        if (instance instanceof ImmutableBotResults) {
            return (ImmutableBotResults)instance;
        }
        return ImmutableBotResults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_QUERY_ID = 1L;
        private static final long INIT_BIT_CACHE_TIME = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_GALLERY = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean gallery;
        private long queryId;
        private String nextOffset;
        private InlineBotSwitchPM switchPm;
        private List<BotInlineResult> results = new ArrayList<BotInlineResult>();
        private int cacheTime;
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BotResults instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BotResults) {
                String nextOffsetValue;
                instance = (BotResults)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.flags(instance.flags());
                InlineBotSwitchPM switchPmValue = instance.switchPm();
                if (switchPmValue != null) {
                    this.switchPm(switchPmValue);
                }
                if ((nextOffsetValue = instance.nextOffset()) != null) {
                    this.nextOffset(nextOffsetValue);
                }
                this.addAllResults(instance.results());
                this.gallery(instance.gallery());
                this.addAllUsers(instance.users());
                this.queryId(instance.queryId());
                this.cacheTime(instance.cacheTime());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder gallery(boolean gallery) {
            this.gallery = gallery;
            this.optBits |= 4L;
            return this;
        }

        public final Builder queryId(long queryId) {
            this.queryId = queryId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder nextOffset(@Nullable String nextOffset) {
            this.nextOffset = nextOffset;
            return this;
        }

        public final Builder switchPm(@Nullable InlineBotSwitchPM switchPm) {
            this.switchPm = switchPm;
            return this;
        }

        public final Builder addResult(BotInlineResult element) {
            this.results.add(Objects.requireNonNull(element, "results element"));
            return this;
        }

        public final Builder addResults(BotInlineResult ... elements) {
            for (BotInlineResult element : elements) {
                this.results.add(Objects.requireNonNull(element, "results element"));
            }
            return this;
        }

        public final Builder results(Iterable<? extends BotInlineResult> elements) {
            this.results.clear();
            return this.addAllResults(elements);
        }

        public final Builder addAllResults(Iterable<? extends BotInlineResult> elements) {
            for (BotInlineResult botInlineResult : elements) {
                this.results.add(Objects.requireNonNull(botInlineResult, "results element"));
            }
            return this;
        }

        public final Builder cacheTime(int cacheTime) {
            this.cacheTime = cacheTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableBotResults build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBotResults(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean galleryIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("queryId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cacheTime");
            }
            return "Cannot build BotResults, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte galleryBuildStage = 0;
        private boolean gallery;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableBotResults.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableBotResults.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean gallery() {
            if (this.galleryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.galleryBuildStage == 0) {
                this.galleryBuildStage = (byte)-1;
                this.gallery = ImmutableBotResults.this.galleryInitialize();
                this.galleryBuildStage = 1;
            }
            return this.gallery;
        }

        void gallery(boolean gallery) {
            this.gallery = gallery;
            this.galleryBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.galleryBuildStage == -1) {
                attributes.add("gallery");
            }
            return "Cannot build BotResults, attribute initializers form cycle " + attributes;
        }
    }
}

