/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Chat;
import telegram4j.tl.Message;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.ChannelMessages;
import telegram4j.tl.messages.Messages;

public final class ImmutableChannelMessages
implements ChannelMessages {
    private final int identifier;
    private final int flags;
    private final boolean inexact;
    private final int pts;
    private final int count;
    @Nullable
    private final Integer offsetIdOffset;
    private final List<Message> messages;
    private final List<Chat> chats;
    private final List<User> users;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChannelMessages(int pts, int count) {
        this.pts = pts;
        this.count = count;
        this.offsetIdOffset = null;
        this.messages = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inexact = this.initShim.inexact();
        this.initShim = null;
    }

    private ImmutableChannelMessages(Builder builder) {
        this.pts = builder.pts;
        this.count = builder.count;
        this.offsetIdOffset = builder.offsetIdOffset;
        this.messages = ImmutableChannelMessages.createUnmodifiableList(true, builder.messages);
        this.chats = ImmutableChannelMessages.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableChannelMessages.createUnmodifiableList(true, builder.users);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.inexactIsSet()) {
            this.initShim.inexact(builder.inexact);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inexact = this.initShim.inexact();
        this.initShim = null;
    }

    private ImmutableChannelMessages(int identifier, int flags, boolean inexact, int pts, int count, @Nullable Integer offsetIdOffset, List<Message> messages, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.flags = flags;
        this.inexact = inexact;
        this.pts = pts;
        this.count = count;
        this.offsetIdOffset = offsetIdOffset;
        this.messages = messages;
        this.chats = chats;
        this.users = users;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChannelMessages.super.identifier();
    }

    private int flagsInitialize() {
        return ChannelMessages.super.flags();
    }

    private boolean inexactInitialize() {
        return ChannelMessages.super.inexact();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean inexact() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inexact() : this.inexact;
    }

    @Override
    public int pts() {
        return this.pts;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    @Nullable
    public Integer offsetIdOffset() {
        return this.offsetIdOffset;
    }

    @Override
    public List<Message> messages() {
        return this.messages;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableChannelMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChannelMessages(value, this.flags, this.inexact, this.pts, this.count, this.offsetIdOffset, this.messages, this.chats, this.users);
    }

    public final ImmutableChannelMessages withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChannelMessages(this.identifier, value, this.inexact, this.pts, this.count, this.offsetIdOffset, this.messages, this.chats, this.users);
    }

    public final ImmutableChannelMessages withInexact(boolean value) {
        if (this.inexact == value) {
            return this;
        }
        return new ImmutableChannelMessages(this.identifier, this.flags, value, this.pts, this.count, this.offsetIdOffset, this.messages, this.chats, this.users);
    }

    public final ImmutableChannelMessages withPts(int value) {
        if (this.pts == value) {
            return this;
        }
        return new ImmutableChannelMessages(this.identifier, this.flags, this.inexact, value, this.count, this.offsetIdOffset, this.messages, this.chats, this.users);
    }

    public final ImmutableChannelMessages withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableChannelMessages(this.identifier, this.flags, this.inexact, this.pts, value, this.offsetIdOffset, this.messages, this.chats, this.users);
    }

    public final ImmutableChannelMessages withOffsetIdOffset(@Nullable Integer value) {
        if (Objects.equals(this.offsetIdOffset, value)) {
            return this;
        }
        return new ImmutableChannelMessages(this.identifier, this.flags, this.inexact, this.pts, this.count, value, this.messages, this.chats, this.users);
    }

    public final ImmutableChannelMessages withMessages(Message ... elements) {
        List<Message> newValue = ImmutableChannelMessages.createUnmodifiableList(false, ImmutableChannelMessages.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannelMessages(this.identifier, this.flags, this.inexact, this.pts, this.count, this.offsetIdOffset, newValue, this.chats, this.users);
    }

    public final ImmutableChannelMessages withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Message> newValue = ImmutableChannelMessages.createUnmodifiableList(false, ImmutableChannelMessages.createSafeList(elements, true, false));
        return new ImmutableChannelMessages(this.identifier, this.flags, this.inexact, this.pts, this.count, this.offsetIdOffset, newValue, this.chats, this.users);
    }

    public final ImmutableChannelMessages withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableChannelMessages.createUnmodifiableList(false, ImmutableChannelMessages.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannelMessages(this.identifier, this.flags, this.inexact, this.pts, this.count, this.offsetIdOffset, this.messages, newValue, this.users);
    }

    public final ImmutableChannelMessages withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableChannelMessages.createUnmodifiableList(false, ImmutableChannelMessages.createSafeList(elements, true, false));
        return new ImmutableChannelMessages(this.identifier, this.flags, this.inexact, this.pts, this.count, this.offsetIdOffset, this.messages, newValue, this.users);
    }

    public final ImmutableChannelMessages withUsers(User ... elements) {
        List<User> newValue = ImmutableChannelMessages.createUnmodifiableList(false, ImmutableChannelMessages.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChannelMessages(this.identifier, this.flags, this.inexact, this.pts, this.count, this.offsetIdOffset, this.messages, this.chats, newValue);
    }

    public final ImmutableChannelMessages withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableChannelMessages.createUnmodifiableList(false, ImmutableChannelMessages.createSafeList(elements, true, false));
        return new ImmutableChannelMessages(this.identifier, this.flags, this.inexact, this.pts, this.count, this.offsetIdOffset, this.messages, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelMessages && this.equalTo(0, (ImmutableChannelMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelMessages another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.inexact == another.inexact && this.pts == another.pts && this.count == another.count && Objects.equals(this.offsetIdOffset, another.offsetIdOffset) && this.messages.equals(another.messages) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.inexact);
        h += (h << 5) + this.pts;
        h += (h << 5) + this.count;
        h += (h << 5) + Objects.hashCode(this.offsetIdOffset);
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "ChannelMessages{identifier=" + this.identifier + ", flags=" + this.flags + ", inexact=" + this.inexact + ", pts=" + this.pts + ", count=" + this.count + ", offsetIdOffset=" + this.offsetIdOffset + ", messages=" + this.messages + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableChannelMessages of(int pts, int count) {
        return new ImmutableChannelMessages(pts, count);
    }

    public static ImmutableChannelMessages copyOf(ChannelMessages instance) {
        if (instance instanceof ImmutableChannelMessages) {
            return (ImmutableChannelMessages)instance;
        }
        return ImmutableChannelMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PTS = 1L;
        private static final long INIT_BIT_COUNT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_INEXACT = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean inexact;
        private int pts;
        private int count;
        private Integer offsetIdOffset;
        private List<Message> messages = new ArrayList<Message>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChannelMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Messages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelMessages) {
                Integer offsetIdOffsetValue;
                instance = (ChannelMessages)object;
                this.inexact(instance.inexact());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((offsetIdOffsetValue = instance.offsetIdOffset()) != null) {
                    this.offsetIdOffset(offsetIdOffsetValue);
                }
                this.flags(instance.flags());
                this.count(instance.count());
                this.addAllChats(instance.chats());
                this.addAllMessages(instance.messages());
                this.pts(instance.pts());
                this.addAllUsers(instance.users());
            }
            if (object instanceof Messages) {
                instance = (Messages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder inexact(boolean inexact) {
            this.inexact = inexact;
            this.optBits |= 4L;
            return this;
        }

        public final Builder pts(int pts) {
            this.pts = pts;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder offsetIdOffset(@Nullable Integer offsetIdOffset) {
            this.offsetIdOffset = offsetIdOffset;
            return this;
        }

        public final Builder addMessage(Message element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(Message ... elements) {
            for (Message element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            for (Message message : elements) {
                this.messages.add(Objects.requireNonNull(message, "messages element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableChannelMessages build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean inexactIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pts");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build ChannelMessages, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte inexactBuildStage = 0;
        private boolean inexact;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChannelMessages.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChannelMessages.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean inexact() {
            if (this.inexactBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inexactBuildStage == 0) {
                this.inexactBuildStage = (byte)-1;
                this.inexact = ImmutableChannelMessages.this.inexactInitialize();
                this.inexactBuildStage = 1;
            }
            return this.inexact;
        }

        void inexact(boolean inexact) {
            this.inexact = inexact;
            this.inexactBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.inexactBuildStage == -1) {
                attributes.add("inexact");
            }
            return "Cannot build ChannelMessages, attribute initializers form cycle " + attributes;
        }
    }
}

