/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.ChatAdminWithInvites;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.ChatAdminsWithInvites;

public final class ImmutableChatAdminsWithInvites
implements ChatAdminsWithInvites {
    private final int identifier;
    private final List<ChatAdminWithInvites> admins;
    private final List<User> users;

    private ImmutableChatAdminsWithInvites(Builder builder) {
        this.admins = ImmutableChatAdminsWithInvites.createUnmodifiableList(true, builder.admins);
        this.users = ImmutableChatAdminsWithInvites.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChatAdminsWithInvites.super.identifier();
    }

    private ImmutableChatAdminsWithInvites(int identifier, List<ChatAdminWithInvites> admins, List<User> users) {
        this.identifier = identifier;
        this.admins = admins;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<ChatAdminWithInvites> admins() {
        return this.admins;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableChatAdminsWithInvites withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatAdminsWithInvites(value, this.admins, this.users);
    }

    public final ImmutableChatAdminsWithInvites withAdmins(ChatAdminWithInvites ... elements) {
        List<ChatAdminWithInvites> newValue = ImmutableChatAdminsWithInvites.createUnmodifiableList(false, ImmutableChatAdminsWithInvites.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChatAdminsWithInvites(this.identifier, newValue, this.users);
    }

    public final ImmutableChatAdminsWithInvites withAdmins(Iterable<? extends ChatAdminWithInvites> elements) {
        if (this.admins == elements) {
            return this;
        }
        List<ChatAdminWithInvites> newValue = ImmutableChatAdminsWithInvites.createUnmodifiableList(false, ImmutableChatAdminsWithInvites.createSafeList(elements, true, false));
        return new ImmutableChatAdminsWithInvites(this.identifier, newValue, this.users);
    }

    public final ImmutableChatAdminsWithInvites withUsers(User ... elements) {
        List<User> newValue = ImmutableChatAdminsWithInvites.createUnmodifiableList(false, ImmutableChatAdminsWithInvites.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChatAdminsWithInvites(this.identifier, this.admins, newValue);
    }

    public final ImmutableChatAdminsWithInvites withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableChatAdminsWithInvites.createUnmodifiableList(false, ImmutableChatAdminsWithInvites.createSafeList(elements, true, false));
        return new ImmutableChatAdminsWithInvites(this.identifier, this.admins, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatAdminsWithInvites && this.equalTo(0, (ImmutableChatAdminsWithInvites)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatAdminsWithInvites another) {
        return this.identifier == another.identifier && this.admins.equals(another.admins) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.admins.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "ChatAdminsWithInvites{identifier=" + this.identifier + ", admins=" + this.admins + ", users=" + this.users + "}";
    }

    public static ImmutableChatAdminsWithInvites copyOf(ChatAdminsWithInvites instance) {
        if (instance instanceof ImmutableChatAdminsWithInvites) {
            return (ImmutableChatAdminsWithInvites)instance;
        }
        return ImmutableChatAdminsWithInvites.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<ChatAdminWithInvites> admins = new ArrayList<ChatAdminWithInvites>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(ChatAdminsWithInvites instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChatAdminsWithInvites instance;
            long bits = 0L;
            if (object instanceof ChatAdminsWithInvites) {
                instance = (ChatAdminsWithInvites)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllAdmins(instance.admins());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addAdmin(ChatAdminWithInvites element) {
            this.admins.add(Objects.requireNonNull(element, "admins element"));
            return this;
        }

        public final Builder addAdmins(ChatAdminWithInvites ... elements) {
            for (ChatAdminWithInvites element : elements) {
                this.admins.add(Objects.requireNonNull(element, "admins element"));
            }
            return this;
        }

        public final Builder admins(Iterable<? extends ChatAdminWithInvites> elements) {
            this.admins.clear();
            return this.addAllAdmins(elements);
        }

        public final Builder addAllAdmins(Iterable<? extends ChatAdminWithInvites> elements) {
            for (ChatAdminWithInvites chatAdminWithInvites : elements) {
                this.admins.add(Objects.requireNonNull(chatAdminWithInvites, "admins element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableChatAdminsWithInvites build() {
            return new ImmutableChatAdminsWithInvites(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

