/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.ChatFull;

public final class ImmutableChatFull
implements ChatFull {
    private final int identifier;
    private final telegram4j.tl.ChatFull fullChat;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableChatFull(telegram4j.tl.ChatFull fullChat) {
        this.fullChat = Objects.requireNonNull(fullChat, "fullChat");
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = ChatFull.super.identifier();
    }

    private ImmutableChatFull(Builder builder) {
        this.fullChat = builder.fullChat;
        this.chats = ImmutableChatFull.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableChatFull.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChatFull.super.identifier();
    }

    private ImmutableChatFull(int identifier, telegram4j.tl.ChatFull fullChat, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.fullChat = fullChat;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public telegram4j.tl.ChatFull fullChat() {
        return this.fullChat;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableChatFull withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatFull(value, this.fullChat, this.chats, this.users);
    }

    public final ImmutableChatFull withFullChat(telegram4j.tl.ChatFull value) {
        if (this.fullChat == value) {
            return this;
        }
        telegram4j.tl.ChatFull newValue = Objects.requireNonNull(value, "fullChat");
        return new ImmutableChatFull(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableChatFull withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableChatFull.createUnmodifiableList(false, ImmutableChatFull.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChatFull(this.identifier, this.fullChat, newValue, this.users);
    }

    public final ImmutableChatFull withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableChatFull.createUnmodifiableList(false, ImmutableChatFull.createSafeList(elements, true, false));
        return new ImmutableChatFull(this.identifier, this.fullChat, newValue, this.users);
    }

    public final ImmutableChatFull withUsers(User ... elements) {
        List<User> newValue = ImmutableChatFull.createUnmodifiableList(false, ImmutableChatFull.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChatFull(this.identifier, this.fullChat, this.chats, newValue);
    }

    public final ImmutableChatFull withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableChatFull.createUnmodifiableList(false, ImmutableChatFull.createSafeList(elements, true, false));
        return new ImmutableChatFull(this.identifier, this.fullChat, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatFull && this.equalTo(0, (ImmutableChatFull)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatFull another) {
        return this.identifier == another.identifier && this.fullChat.equals(another.fullChat) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.fullChat.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "ChatFull{identifier=" + this.identifier + ", fullChat=" + this.fullChat + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableChatFull of(telegram4j.tl.ChatFull fullChat) {
        return new ImmutableChatFull(fullChat);
    }

    public static ImmutableChatFull copyOf(ChatFull instance) {
        if (instance instanceof ImmutableChatFull) {
            return (ImmutableChatFull)instance;
        }
        return ImmutableChatFull.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_FULL_CHAT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private telegram4j.tl.ChatFull fullChat;
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatFull instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatFull) {
                instance = (ChatFull)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.fullChat(instance.fullChat());
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder fullChat(telegram4j.tl.ChatFull fullChat) {
            this.fullChat = Objects.requireNonNull(fullChat, "fullChat");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableChatFull build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatFull(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fullChat");
            }
            return "Cannot build ChatFull, some of required attributes are not set " + attributes;
        }
    }
}

