/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.ChatInviteImporter;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.ChatInviteImporters;

public final class ImmutableChatInviteImporters
implements ChatInviteImporters {
    private final int identifier;
    private final int count;
    private final List<ChatInviteImporter> importers;
    private final List<User> users;

    private ImmutableChatInviteImporters(int count) {
        this.count = count;
        this.importers = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = ChatInviteImporters.super.identifier();
    }

    private ImmutableChatInviteImporters(Builder builder) {
        this.count = builder.count;
        this.importers = ImmutableChatInviteImporters.createUnmodifiableList(true, builder.importers);
        this.users = ImmutableChatInviteImporters.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChatInviteImporters.super.identifier();
    }

    private ImmutableChatInviteImporters(int identifier, int count, List<ChatInviteImporter> importers, List<User> users) {
        this.identifier = identifier;
        this.count = count;
        this.importers = importers;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<ChatInviteImporter> importers() {
        return this.importers;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableChatInviteImporters withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatInviteImporters(value, this.count, this.importers, this.users);
    }

    public final ImmutableChatInviteImporters withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableChatInviteImporters(this.identifier, value, this.importers, this.users);
    }

    public final ImmutableChatInviteImporters withImporters(ChatInviteImporter ... elements) {
        List<ChatInviteImporter> newValue = ImmutableChatInviteImporters.createUnmodifiableList(false, ImmutableChatInviteImporters.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChatInviteImporters(this.identifier, this.count, newValue, this.users);
    }

    public final ImmutableChatInviteImporters withImporters(Iterable<? extends ChatInviteImporter> elements) {
        if (this.importers == elements) {
            return this;
        }
        List<ChatInviteImporter> newValue = ImmutableChatInviteImporters.createUnmodifiableList(false, ImmutableChatInviteImporters.createSafeList(elements, true, false));
        return new ImmutableChatInviteImporters(this.identifier, this.count, newValue, this.users);
    }

    public final ImmutableChatInviteImporters withUsers(User ... elements) {
        List<User> newValue = ImmutableChatInviteImporters.createUnmodifiableList(false, ImmutableChatInviteImporters.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChatInviteImporters(this.identifier, this.count, this.importers, newValue);
    }

    public final ImmutableChatInviteImporters withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableChatInviteImporters.createUnmodifiableList(false, ImmutableChatInviteImporters.createSafeList(elements, true, false));
        return new ImmutableChatInviteImporters(this.identifier, this.count, this.importers, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatInviteImporters && this.equalTo(0, (ImmutableChatInviteImporters)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatInviteImporters another) {
        return this.identifier == another.identifier && this.count == another.count && this.importers.equals(another.importers) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.count;
        h += (h << 5) + this.importers.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "ChatInviteImporters{identifier=" + this.identifier + ", count=" + this.count + ", importers=" + this.importers + ", users=" + this.users + "}";
    }

    public static ImmutableChatInviteImporters of(int count) {
        return new ImmutableChatInviteImporters(count);
    }

    public static ImmutableChatInviteImporters copyOf(ChatInviteImporters instance) {
        if (instance instanceof ImmutableChatInviteImporters) {
            return (ImmutableChatInviteImporters)instance;
        }
        return ImmutableChatInviteImporters.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int count;
        private List<ChatInviteImporter> importers = new ArrayList<ChatInviteImporter>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatInviteImporters instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatInviteImporters) {
                instance = (ChatInviteImporters)object;
                this.count(instance.count());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllImporters(instance.importers());
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addImporter(ChatInviteImporter element) {
            this.importers.add(Objects.requireNonNull(element, "importers element"));
            return this;
        }

        public final Builder addImporters(ChatInviteImporter ... elements) {
            for (ChatInviteImporter element : elements) {
                this.importers.add(Objects.requireNonNull(element, "importers element"));
            }
            return this;
        }

        public final Builder importers(Iterable<? extends ChatInviteImporter> elements) {
            this.importers.clear();
            return this.addAllImporters(elements);
        }

        public final Builder addAllImporters(Iterable<? extends ChatInviteImporter> elements) {
            for (ChatInviteImporter chatInviteImporter : elements) {
                this.importers.add(Objects.requireNonNull(chatInviteImporter, "importers element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableChatInviteImporters build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatInviteImporters(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build ChatInviteImporters, some of required attributes are not set " + attributes;
        }
    }
}

