/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.Chats;
import telegram4j.tl.messages.ChatsSlice;

public final class ImmutableChatsSlice
implements ChatsSlice {
    private final int identifier;
    private final int count;
    private final List<Chat> chats;

    private ImmutableChatsSlice(int count) {
        this.count = count;
        this.chats = Collections.emptyList();
        this.identifier = ChatsSlice.super.identifier();
    }

    private ImmutableChatsSlice(Builder builder) {
        this.count = builder.count;
        this.chats = ImmutableChatsSlice.createUnmodifiableList(true, builder.chats);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChatsSlice.super.identifier();
    }

    private ImmutableChatsSlice(int identifier, int count, List<Chat> chats) {
        this.identifier = identifier;
        this.count = count;
        this.chats = chats;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    public final ImmutableChatsSlice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChatsSlice(value, this.count, this.chats);
    }

    public final ImmutableChatsSlice withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableChatsSlice(this.identifier, value, this.chats);
    }

    public final ImmutableChatsSlice withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableChatsSlice.createUnmodifiableList(false, ImmutableChatsSlice.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableChatsSlice(this.identifier, this.count, newValue);
    }

    public final ImmutableChatsSlice withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableChatsSlice.createUnmodifiableList(false, ImmutableChatsSlice.createSafeList(elements, true, false));
        return new ImmutableChatsSlice(this.identifier, this.count, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChatsSlice && this.equalTo(0, (ImmutableChatsSlice)another);
    }

    private boolean equalTo(int synthetic, ImmutableChatsSlice another) {
        return this.identifier == another.identifier && this.count == another.count && this.chats.equals(another.chats);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.count;
        h += (h << 5) + this.chats.hashCode();
        return h;
    }

    public String toString() {
        return "ChatsSlice{identifier=" + this.identifier + ", count=" + this.count + ", chats=" + this.chats + "}";
    }

    public static ImmutableChatsSlice of(int count) {
        return new ImmutableChatsSlice(count);
    }

    public static ImmutableChatsSlice copyOf(ChatsSlice instance) {
        if (instance instanceof ImmutableChatsSlice) {
            return (ImmutableChatsSlice)instance;
        }
        return ImmutableChatsSlice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int count;
        private List<Chat> chats = new ArrayList<Chat>();

        private Builder() {
        }

        public final Builder from(Chats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatsSlice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Chats instance;
            long bits = 0L;
            if (object instanceof Chats) {
                instance = (Chats)object;
                if ((bits & 2L) == 0L) {
                    this.addAllChats(instance.chats());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatsSlice) {
                instance = (ChatsSlice)object;
                this.count(instance.count());
                if ((bits & 2L) == 0L) {
                    this.addAllChats(instance.chats());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public ImmutableChatsSlice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChatsSlice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build ChatsSlice, some of required attributes are not set " + attributes;
        }
    }
}

