/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.CheckedHistoryImportPeer;

public final class ImmutableCheckedHistoryImportPeer
implements CheckedHistoryImportPeer {
    private final int identifier;
    private final String confirmText;

    private ImmutableCheckedHistoryImportPeer(String confirmText) {
        this.confirmText = Objects.requireNonNull(confirmText, "confirmText");
        this.identifier = CheckedHistoryImportPeer.super.identifier();
    }

    private ImmutableCheckedHistoryImportPeer(Builder builder) {
        this.confirmText = builder.confirmText;
        this.identifier = builder.identifierIsSet() ? builder.identifier : CheckedHistoryImportPeer.super.identifier();
    }

    private ImmutableCheckedHistoryImportPeer(int identifier, String confirmText) {
        this.identifier = identifier;
        this.confirmText = confirmText;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String confirmText() {
        return this.confirmText;
    }

    public final ImmutableCheckedHistoryImportPeer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCheckedHistoryImportPeer(value, this.confirmText);
    }

    public final ImmutableCheckedHistoryImportPeer withConfirmText(String value) {
        String newValue = Objects.requireNonNull(value, "confirmText");
        if (this.confirmText.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckedHistoryImportPeer(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckedHistoryImportPeer && this.equalTo(0, (ImmutableCheckedHistoryImportPeer)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckedHistoryImportPeer another) {
        return this.identifier == another.identifier && this.confirmText.equals(another.confirmText);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.confirmText.hashCode();
        return h;
    }

    public String toString() {
        return "CheckedHistoryImportPeer{identifier=" + this.identifier + ", confirmText=" + this.confirmText + "}";
    }

    public static ImmutableCheckedHistoryImportPeer of(String confirmText) {
        return new ImmutableCheckedHistoryImportPeer(confirmText);
    }

    public static ImmutableCheckedHistoryImportPeer copyOf(CheckedHistoryImportPeer instance) {
        if (instance instanceof ImmutableCheckedHistoryImportPeer) {
            return (ImmutableCheckedHistoryImportPeer)instance;
        }
        return ImmutableCheckedHistoryImportPeer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CONFIRM_TEXT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String confirmText;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CheckedHistoryImportPeer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof CheckedHistoryImportPeer) {
                instance = (CheckedHistoryImportPeer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.confirmText(instance.confirmText());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder confirmText(String confirmText) {
            this.confirmText = Objects.requireNonNull(confirmText, "confirmText");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCheckedHistoryImportPeer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckedHistoryImportPeer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("confirmText");
            }
            return "Cannot build CheckedHistoryImportPeer, some of required attributes are not set " + attributes;
        }
    }
}

