/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.DhConfig;
import telegram4j.tl.messages.DhConfigNotModified;

public final class ImmutableDhConfigNotModified
implements DhConfigNotModified {
    private final int identifier;
    private final ByteBuf random;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDhConfigNotModified(Builder builder) {
        this.random = builder.random_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableDhConfigNotModified(int identifier, ByteBuf random) {
        this.identifier = identifier;
        this.random = random;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DhConfigNotModified.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf random() {
        return this.random.duplicate();
    }

    public final ImmutableDhConfigNotModified withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDhConfigNotModified(value, this.random);
    }

    public ImmutableDhConfigNotModified withRandom(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.random == newValue) {
            return this;
        }
        return new ImmutableDhConfigNotModified(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDhConfigNotModified && this.equalTo(0, (ImmutableDhConfigNotModified)another);
    }

    private boolean equalTo(int synthetic, ImmutableDhConfigNotModified another) {
        return this.identifier == another.identifier && this.random().equals((Object)another.random());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.random().hashCode();
        return h;
    }

    public String toString() {
        return "DhConfigNotModified{identifier=" + this.identifier + ", random=" + ByteBufUtil.hexDump((ByteBuf)this.random) + "}";
    }

    public static ImmutableDhConfigNotModified copyOf(DhConfigNotModified instance) {
        if (instance instanceof ImmutableDhConfigNotModified) {
            return (ImmutableDhConfigNotModified)instance;
        }
        return ImmutableDhConfigNotModified.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf random_value = null;
        private int identifier;

        private Builder() {
        }

        public final Builder from(DhConfigNotModified instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DhConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DhConfig instance;
            long bits = 0L;
            if (object instanceof DhConfigNotModified) {
                instance = (DhConfigNotModified)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.random(instance.random());
                    bits |= 2L;
                }
            }
            if (object instanceof DhConfig) {
                instance = (DhConfig)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.random(instance.random());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder random(ByteBuf value) {
            this.random_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableDhConfigNotModified build() {
            return new ImmutableDhConfigNotModified(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf random_build() {
            return Objects.requireNonNull(this.random_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDhConfigNotModified.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build DhConfigNotModified, attribute initializers form cycle " + attributes;
        }
    }
}

