/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.Dialogs;
import telegram4j.tl.messages.DialogsNotModified;

public final class ImmutableDialogsNotModified
implements DialogsNotModified {
    private final int identifier;
    private final int count;

    private ImmutableDialogsNotModified(int count) {
        this.count = count;
        this.identifier = DialogsNotModified.super.identifier();
    }

    private ImmutableDialogsNotModified(Builder builder) {
        this.count = builder.count;
        this.identifier = builder.identifierIsSet() ? builder.identifier : DialogsNotModified.super.identifier();
    }

    private ImmutableDialogsNotModified(int identifier, int count) {
        this.identifier = identifier;
        this.count = count;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int count() {
        return this.count;
    }

    public final ImmutableDialogsNotModified withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDialogsNotModified(value, this.count);
    }

    public final ImmutableDialogsNotModified withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableDialogsNotModified(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDialogsNotModified && this.equalTo(0, (ImmutableDialogsNotModified)another);
    }

    private boolean equalTo(int synthetic, ImmutableDialogsNotModified another) {
        return this.identifier == another.identifier && this.count == another.count;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.count;
        return h;
    }

    public String toString() {
        return "DialogsNotModified{identifier=" + this.identifier + ", count=" + this.count + "}";
    }

    public static ImmutableDialogsNotModified of(int count) {
        return new ImmutableDialogsNotModified(count);
    }

    public static ImmutableDialogsNotModified copyOf(DialogsNotModified instance) {
        if (instance instanceof ImmutableDialogsNotModified) {
            return (ImmutableDialogsNotModified)instance;
        }
        return ImmutableDialogsNotModified.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int count;

        private Builder() {
        }

        public final Builder from(Dialogs instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DialogsNotModified instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Dialogs instance;
            long bits = 0L;
            if (object instanceof Dialogs) {
                instance = (Dialogs)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof DialogsNotModified) {
                instance = (DialogsNotModified)object;
                this.count(instance.count());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDialogsNotModified build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDialogsNotModified(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build DialogsNotModified, some of required attributes are not set " + attributes;
        }
    }
}

