/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Chat;
import telegram4j.tl.Message;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.DiscussionMessage;

public final class ImmutableDiscussionMessage
implements DiscussionMessage {
    private final int identifier;
    private final int flags;
    private final List<Message> messages;
    @Nullable
    private final Integer maxId;
    @Nullable
    private final Integer readInboxMaxId;
    @Nullable
    private final Integer readOutboxMaxId;
    private final int unreadCount;
    private final List<Chat> chats;
    private final List<User> users;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDiscussionMessage(int unreadCount) {
        this.unreadCount = unreadCount;
        this.messages = Collections.emptyList();
        this.maxId = null;
        this.readInboxMaxId = null;
        this.readOutboxMaxId = null;
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableDiscussionMessage(Builder builder) {
        this.messages = ImmutableDiscussionMessage.createUnmodifiableList(true, builder.messages);
        this.maxId = builder.maxId;
        this.readInboxMaxId = builder.readInboxMaxId;
        this.readOutboxMaxId = builder.readOutboxMaxId;
        this.unreadCount = builder.unreadCount;
        this.chats = ImmutableDiscussionMessage.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableDiscussionMessage.createUnmodifiableList(true, builder.users);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableDiscussionMessage(int identifier, int flags, List<Message> messages, @Nullable Integer maxId, @Nullable Integer readInboxMaxId, @Nullable Integer readOutboxMaxId, int unreadCount, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.flags = flags;
        this.messages = messages;
        this.maxId = maxId;
        this.readInboxMaxId = readInboxMaxId;
        this.readOutboxMaxId = readOutboxMaxId;
        this.unreadCount = unreadCount;
        this.chats = chats;
        this.users = users;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DiscussionMessage.super.identifier();
    }

    private int flagsInitialize() {
        return DiscussionMessage.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public List<Message> messages() {
        return this.messages;
    }

    @Override
    @Nullable
    public Integer maxId() {
        return this.maxId;
    }

    @Override
    @Nullable
    public Integer readInboxMaxId() {
        return this.readInboxMaxId;
    }

    @Override
    @Nullable
    public Integer readOutboxMaxId() {
        return this.readOutboxMaxId;
    }

    @Override
    public int unreadCount() {
        return this.unreadCount;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableDiscussionMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDiscussionMessage(value, this.flags, this.messages, this.maxId, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chats, this.users);
    }

    public final ImmutableDiscussionMessage withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableDiscussionMessage(this.identifier, value, this.messages, this.maxId, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chats, this.users);
    }

    public final ImmutableDiscussionMessage withMessages(Message ... elements) {
        List<Message> newValue = ImmutableDiscussionMessage.createUnmodifiableList(false, ImmutableDiscussionMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDiscussionMessage(this.identifier, this.flags, newValue, this.maxId, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chats, this.users);
    }

    public final ImmutableDiscussionMessage withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Message> newValue = ImmutableDiscussionMessage.createUnmodifiableList(false, ImmutableDiscussionMessage.createSafeList(elements, true, false));
        return new ImmutableDiscussionMessage(this.identifier, this.flags, newValue, this.maxId, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chats, this.users);
    }

    public final ImmutableDiscussionMessage withMaxId(@Nullable Integer value) {
        if (Objects.equals(this.maxId, value)) {
            return this;
        }
        return new ImmutableDiscussionMessage(this.identifier, this.flags, this.messages, value, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chats, this.users);
    }

    public final ImmutableDiscussionMessage withReadInboxMaxId(@Nullable Integer value) {
        if (Objects.equals(this.readInboxMaxId, value)) {
            return this;
        }
        return new ImmutableDiscussionMessage(this.identifier, this.flags, this.messages, this.maxId, value, this.readOutboxMaxId, this.unreadCount, this.chats, this.users);
    }

    public final ImmutableDiscussionMessage withReadOutboxMaxId(@Nullable Integer value) {
        if (Objects.equals(this.readOutboxMaxId, value)) {
            return this;
        }
        return new ImmutableDiscussionMessage(this.identifier, this.flags, this.messages, this.maxId, this.readInboxMaxId, value, this.unreadCount, this.chats, this.users);
    }

    public final ImmutableDiscussionMessage withUnreadCount(int value) {
        if (this.unreadCount == value) {
            return this;
        }
        return new ImmutableDiscussionMessage(this.identifier, this.flags, this.messages, this.maxId, this.readInboxMaxId, this.readOutboxMaxId, value, this.chats, this.users);
    }

    public final ImmutableDiscussionMessage withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableDiscussionMessage.createUnmodifiableList(false, ImmutableDiscussionMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDiscussionMessage(this.identifier, this.flags, this.messages, this.maxId, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, newValue, this.users);
    }

    public final ImmutableDiscussionMessage withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableDiscussionMessage.createUnmodifiableList(false, ImmutableDiscussionMessage.createSafeList(elements, true, false));
        return new ImmutableDiscussionMessage(this.identifier, this.flags, this.messages, this.maxId, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, newValue, this.users);
    }

    public final ImmutableDiscussionMessage withUsers(User ... elements) {
        List<User> newValue = ImmutableDiscussionMessage.createUnmodifiableList(false, ImmutableDiscussionMessage.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDiscussionMessage(this.identifier, this.flags, this.messages, this.maxId, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chats, newValue);
    }

    public final ImmutableDiscussionMessage withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableDiscussionMessage.createUnmodifiableList(false, ImmutableDiscussionMessage.createSafeList(elements, true, false));
        return new ImmutableDiscussionMessage(this.identifier, this.flags, this.messages, this.maxId, this.readInboxMaxId, this.readOutboxMaxId, this.unreadCount, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiscussionMessage && this.equalTo(0, (ImmutableDiscussionMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableDiscussionMessage another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.messages.equals(another.messages) && Objects.equals(this.maxId, another.maxId) && Objects.equals(this.readInboxMaxId, another.readInboxMaxId) && Objects.equals(this.readOutboxMaxId, another.readOutboxMaxId) && this.unreadCount == another.unreadCount && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + Objects.hashCode(this.maxId);
        h += (h << 5) + Objects.hashCode(this.readInboxMaxId);
        h += (h << 5) + Objects.hashCode(this.readOutboxMaxId);
        h += (h << 5) + this.unreadCount;
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "DiscussionMessage{identifier=" + this.identifier + ", flags=" + this.flags + ", messages=" + this.messages + ", maxId=" + this.maxId + ", readInboxMaxId=" + this.readInboxMaxId + ", readOutboxMaxId=" + this.readOutboxMaxId + ", unreadCount=" + this.unreadCount + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableDiscussionMessage of(int unreadCount) {
        return new ImmutableDiscussionMessage(unreadCount);
    }

    public static ImmutableDiscussionMessage copyOf(DiscussionMessage instance) {
        if (instance instanceof ImmutableDiscussionMessage) {
            return (ImmutableDiscussionMessage)instance;
        }
        return ImmutableDiscussionMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_UNREAD_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private List<Message> messages = new ArrayList<Message>();
        private Integer maxId;
        private Integer readInboxMaxId;
        private Integer readOutboxMaxId;
        private int unreadCount;
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(DiscussionMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DiscussionMessage instance;
            long bits = 0L;
            if (object instanceof DiscussionMessage) {
                Integer readInboxMaxIdValue;
                Integer maxIdValue;
                Integer readOutboxMaxIdValue;
                instance = (DiscussionMessage)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((readOutboxMaxIdValue = instance.readOutboxMaxId()) != null) {
                    this.readOutboxMaxId(readOutboxMaxIdValue);
                }
                if ((maxIdValue = instance.maxId()) != null) {
                    this.maxId(maxIdValue);
                }
                if ((readInboxMaxIdValue = instance.readInboxMaxId()) != null) {
                    this.readInboxMaxId(readInboxMaxIdValue);
                }
                this.flags(instance.flags());
                this.addAllChats(instance.chats());
                this.addAllMessages(instance.messages());
                this.unreadCount(instance.unreadCount());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder addMessage(Message element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(Message ... elements) {
            for (Message element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            for (Message message : elements) {
                this.messages.add(Objects.requireNonNull(message, "messages element"));
            }
            return this;
        }

        public final Builder maxId(@Nullable Integer maxId) {
            this.maxId = maxId;
            return this;
        }

        public final Builder readInboxMaxId(@Nullable Integer readInboxMaxId) {
            this.readInboxMaxId = readInboxMaxId;
            return this;
        }

        public final Builder readOutboxMaxId(@Nullable Integer readOutboxMaxId) {
            this.readOutboxMaxId = readOutboxMaxId;
            return this;
        }

        public final Builder unreadCount(int unreadCount) {
            this.unreadCount = unreadCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableDiscussionMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiscussionMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("unreadCount");
            }
            return "Cannot build DiscussionMessage, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDiscussionMessage.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableDiscussionMessage.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build DiscussionMessage, attribute initializers form cycle " + attributes;
        }
    }
}

