/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.ExportedChatInvite;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.ExportedChatInvites;

public final class ImmutableExportedChatInvites
implements ExportedChatInvites {
    private final int identifier;
    private final int count;
    private final List<ExportedChatInvite> invites;
    private final List<User> users;

    private ImmutableExportedChatInvites(int count) {
        this.count = count;
        this.invites = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = ExportedChatInvites.super.identifier();
    }

    private ImmutableExportedChatInvites(Builder builder) {
        this.count = builder.count;
        this.invites = ImmutableExportedChatInvites.createUnmodifiableList(true, builder.invites);
        this.users = ImmutableExportedChatInvites.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : ExportedChatInvites.super.identifier();
    }

    private ImmutableExportedChatInvites(int identifier, int count, List<ExportedChatInvite> invites, List<User> users) {
        this.identifier = identifier;
        this.count = count;
        this.invites = invites;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<ExportedChatInvite> invites() {
        return this.invites;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableExportedChatInvites withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableExportedChatInvites(value, this.count, this.invites, this.users);
    }

    public final ImmutableExportedChatInvites withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableExportedChatInvites(this.identifier, value, this.invites, this.users);
    }

    public final ImmutableExportedChatInvites withInvites(ExportedChatInvite ... elements) {
        List<ExportedChatInvite> newValue = ImmutableExportedChatInvites.createUnmodifiableList(false, ImmutableExportedChatInvites.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableExportedChatInvites(this.identifier, this.count, newValue, this.users);
    }

    public final ImmutableExportedChatInvites withInvites(Iterable<? extends ExportedChatInvite> elements) {
        if (this.invites == elements) {
            return this;
        }
        List<ExportedChatInvite> newValue = ImmutableExportedChatInvites.createUnmodifiableList(false, ImmutableExportedChatInvites.createSafeList(elements, true, false));
        return new ImmutableExportedChatInvites(this.identifier, this.count, newValue, this.users);
    }

    public final ImmutableExportedChatInvites withUsers(User ... elements) {
        List<User> newValue = ImmutableExportedChatInvites.createUnmodifiableList(false, ImmutableExportedChatInvites.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableExportedChatInvites(this.identifier, this.count, this.invites, newValue);
    }

    public final ImmutableExportedChatInvites withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableExportedChatInvites.createUnmodifiableList(false, ImmutableExportedChatInvites.createSafeList(elements, true, false));
        return new ImmutableExportedChatInvites(this.identifier, this.count, this.invites, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportedChatInvites && this.equalTo(0, (ImmutableExportedChatInvites)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportedChatInvites another) {
        return this.identifier == another.identifier && this.count == another.count && this.invites.equals(another.invites) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.count;
        h += (h << 5) + this.invites.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "ExportedChatInvites{identifier=" + this.identifier + ", count=" + this.count + ", invites=" + this.invites + ", users=" + this.users + "}";
    }

    public static ImmutableExportedChatInvites of(int count) {
        return new ImmutableExportedChatInvites(count);
    }

    public static ImmutableExportedChatInvites copyOf(ExportedChatInvites instance) {
        if (instance instanceof ImmutableExportedChatInvites) {
            return (ImmutableExportedChatInvites)instance;
        }
        return ImmutableExportedChatInvites.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int count;
        private List<ExportedChatInvite> invites = new ArrayList<ExportedChatInvite>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(ExportedChatInvites instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ExportedChatInvites instance;
            long bits = 0L;
            if (object instanceof ExportedChatInvites) {
                instance = (ExportedChatInvites)object;
                this.count(instance.count());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllInvites(instance.invites());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addInvite(ExportedChatInvite element) {
            this.invites.add(Objects.requireNonNull(element, "invites element"));
            return this;
        }

        public final Builder addInvites(ExportedChatInvite ... elements) {
            for (ExportedChatInvite element : elements) {
                this.invites.add(Objects.requireNonNull(element, "invites element"));
            }
            return this;
        }

        public final Builder invites(Iterable<? extends ExportedChatInvite> elements) {
            this.invites.clear();
            return this.addAllInvites(elements);
        }

        public final Builder addAllInvites(Iterable<? extends ExportedChatInvite> elements) {
            for (ExportedChatInvite exportedChatInvite : elements) {
                this.invites.add(Objects.requireNonNull(exportedChatInvite, "invites element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableExportedChatInvites build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExportedChatInvites(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build ExportedChatInvites, some of required attributes are not set " + attributes;
        }
    }
}

