/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.HighScore;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.HighScores;

public final class ImmutableHighScores
implements HighScores {
    private final int identifier;
    private final List<HighScore> scores;
    private final List<User> users;

    private ImmutableHighScores(Builder builder) {
        this.scores = ImmutableHighScores.createUnmodifiableList(true, builder.scores);
        this.users = ImmutableHighScores.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : HighScores.super.identifier();
    }

    private ImmutableHighScores(int identifier, List<HighScore> scores, List<User> users) {
        this.identifier = identifier;
        this.scores = scores;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<HighScore> scores() {
        return this.scores;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableHighScores withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableHighScores(value, this.scores, this.users);
    }

    public final ImmutableHighScores withScores(HighScore ... elements) {
        List<HighScore> newValue = ImmutableHighScores.createUnmodifiableList(false, ImmutableHighScores.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHighScores(this.identifier, newValue, this.users);
    }

    public final ImmutableHighScores withScores(Iterable<? extends HighScore> elements) {
        if (this.scores == elements) {
            return this;
        }
        List<HighScore> newValue = ImmutableHighScores.createUnmodifiableList(false, ImmutableHighScores.createSafeList(elements, true, false));
        return new ImmutableHighScores(this.identifier, newValue, this.users);
    }

    public final ImmutableHighScores withUsers(User ... elements) {
        List<User> newValue = ImmutableHighScores.createUnmodifiableList(false, ImmutableHighScores.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHighScores(this.identifier, this.scores, newValue);
    }

    public final ImmutableHighScores withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableHighScores.createUnmodifiableList(false, ImmutableHighScores.createSafeList(elements, true, false));
        return new ImmutableHighScores(this.identifier, this.scores, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHighScores && this.equalTo(0, (ImmutableHighScores)another);
    }

    private boolean equalTo(int synthetic, ImmutableHighScores another) {
        return this.identifier == another.identifier && this.scores.equals(another.scores) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.scores.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "HighScores{identifier=" + this.identifier + ", scores=" + this.scores + ", users=" + this.users + "}";
    }

    public static ImmutableHighScores copyOf(HighScores instance) {
        if (instance instanceof ImmutableHighScores) {
            return (ImmutableHighScores)instance;
        }
        return ImmutableHighScores.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<HighScore> scores = new ArrayList<HighScore>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(HighScores instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HighScores instance;
            long bits = 0L;
            if (object instanceof HighScores) {
                instance = (HighScores)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllScores(instance.scores());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addScore(HighScore element) {
            this.scores.add(Objects.requireNonNull(element, "scores element"));
            return this;
        }

        public final Builder addScores(HighScore ... elements) {
            for (HighScore element : elements) {
                this.scores.add(Objects.requireNonNull(element, "scores element"));
            }
            return this;
        }

        public final Builder scores(Iterable<? extends HighScore> elements) {
            this.scores.clear();
            return this.addAllScores(elements);
        }

        public final Builder addAllScores(Iterable<? extends HighScore> elements) {
            for (HighScore highScore : elements) {
                this.scores.add(Objects.requireNonNull(highScore, "scores element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableHighScores build() {
            return new ImmutableHighScores(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

