/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.HistoryImportParsed;

public final class ImmutableHistoryImportParsed
implements HistoryImportParsed {
    private final int identifier;
    private final int flags;
    private final boolean pm;
    private final boolean group;
    @Nullable
    private final String title;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableHistoryImportParsed INSTANCE = ImmutableHistoryImportParsed.validate(new ImmutableHistoryImportParsed());

    private ImmutableHistoryImportParsed() {
        this.title = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pm = this.initShim.pm();
        this.group = this.initShim.group();
        this.initShim = null;
    }

    private ImmutableHistoryImportParsed(Builder builder) {
        this.title = builder.title;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.pmIsSet()) {
            this.initShim.pm(builder.pm);
        }
        if (builder.groupIsSet()) {
            this.initShim.group(builder.group);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pm = this.initShim.pm();
        this.group = this.initShim.group();
        this.initShim = null;
    }

    private ImmutableHistoryImportParsed(int identifier, int flags, boolean pm, boolean group, @Nullable String title) {
        this.identifier = identifier;
        this.flags = flags;
        this.pm = pm;
        this.group = group;
        this.title = title;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return HistoryImportParsed.super.identifier();
    }

    private int flagsInitialize() {
        return HistoryImportParsed.super.flags();
    }

    private boolean pmInitialize() {
        return HistoryImportParsed.super.pm();
    }

    private boolean groupInitialize() {
        return HistoryImportParsed.super.group();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean pm() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pm() : this.pm;
    }

    @Override
    public boolean group() {
        InitShim shim = this.initShim;
        return shim != null ? shim.group() : this.group;
    }

    @Override
    @Nullable
    public String title() {
        return this.title;
    }

    public final ImmutableHistoryImportParsed withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableHistoryImportParsed.validate(new ImmutableHistoryImportParsed(value, this.flags, this.pm, this.group, this.title));
    }

    public final ImmutableHistoryImportParsed withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableHistoryImportParsed.validate(new ImmutableHistoryImportParsed(this.identifier, value, this.pm, this.group, this.title));
    }

    public final ImmutableHistoryImportParsed withPm(boolean value) {
        if (this.pm == value) {
            return this;
        }
        return ImmutableHistoryImportParsed.validate(new ImmutableHistoryImportParsed(this.identifier, this.flags, value, this.group, this.title));
    }

    public final ImmutableHistoryImportParsed withGroup(boolean value) {
        if (this.group == value) {
            return this;
        }
        return ImmutableHistoryImportParsed.validate(new ImmutableHistoryImportParsed(this.identifier, this.flags, this.pm, value, this.title));
    }

    public final ImmutableHistoryImportParsed withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return ImmutableHistoryImportParsed.validate(new ImmutableHistoryImportParsed(this.identifier, this.flags, this.pm, this.group, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHistoryImportParsed && this.equalTo(0, (ImmutableHistoryImportParsed)another);
    }

    private boolean equalTo(int synthetic, ImmutableHistoryImportParsed another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.pm == another.pm && this.group == another.group && Objects.equals(this.title, another.title);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.pm);
        h += (h << 5) + Boolean.hashCode(this.group);
        h += (h << 5) + Objects.hashCode(this.title);
        return h;
    }

    public String toString() {
        return "HistoryImportParsed{identifier=" + this.identifier + ", flags=" + this.flags + ", pm=" + this.pm + ", group=" + this.group + ", title=" + this.title + "}";
    }

    public static ImmutableHistoryImportParsed of() {
        return INSTANCE;
    }

    private static ImmutableHistoryImportParsed validate(ImmutableHistoryImportParsed instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableHistoryImportParsed copyOf(HistoryImportParsed instance) {
        if (instance instanceof ImmutableHistoryImportParsed) {
            return (ImmutableHistoryImportParsed)instance;
        }
        return ImmutableHistoryImportParsed.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PM = 4L;
        private static final long OPT_BIT_GROUP = 8L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean pm;
        private boolean group;
        private String title;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HistoryImportParsed instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof HistoryImportParsed) {
                String titleValue;
                instance = (HistoryImportParsed)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((titleValue = instance.title()) != null) {
                    this.title(titleValue);
                }
                this.pm(instance.pm());
                this.group(instance.group());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder pm(boolean pm) {
            this.pm = pm;
            this.optBits |= 4L;
            return this;
        }

        public final Builder group(boolean group) {
            this.group = group;
            this.optBits |= 8L;
            return this;
        }

        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        public ImmutableHistoryImportParsed build() {
            return ImmutableHistoryImportParsed.validate(new ImmutableHistoryImportParsed(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pmIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean groupIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte pmBuildStage = 0;
        private boolean pm;
        private byte groupBuildStage = 0;
        private boolean group;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableHistoryImportParsed.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableHistoryImportParsed.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean pm() {
            if (this.pmBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pmBuildStage == 0) {
                this.pmBuildStage = (byte)-1;
                this.pm = ImmutableHistoryImportParsed.this.pmInitialize();
                this.pmBuildStage = 1;
            }
            return this.pm;
        }

        void pm(boolean pm) {
            this.pm = pm;
            this.pmBuildStage = 1;
        }

        boolean group() {
            if (this.groupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.groupBuildStage == 0) {
                this.groupBuildStage = (byte)-1;
                this.group = ImmutableHistoryImportParsed.this.groupInitialize();
                this.groupBuildStage = 1;
            }
            return this.group;
        }

        void group(boolean group) {
            this.group = group;
            this.groupBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.pmBuildStage == -1) {
                attributes.add("pm");
            }
            if (this.groupBuildStage == -1) {
                attributes.add("group");
            }
            return "Cannot build HistoryImportParsed, attribute initializers form cycle " + attributes;
        }
    }
}

