/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.InactiveChats;

public final class ImmutableInactiveChats
implements InactiveChats {
    private final int identifier;
    private final List<Integer> dates;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableInactiveChats(Builder builder) {
        this.dates = ImmutableInactiveChats.createUnmodifiableList(true, builder.dates);
        this.chats = ImmutableInactiveChats.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableInactiveChats.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : InactiveChats.super.identifier();
    }

    private ImmutableInactiveChats(int identifier, List<Integer> dates, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.dates = dates;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Integer> dates() {
        return this.dates;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableInactiveChats withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInactiveChats(value, this.dates, this.chats, this.users);
    }

    public final ImmutableInactiveChats withDates(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableInactiveChats.createUnmodifiableList(false, wrappedList);
        return new ImmutableInactiveChats(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableInactiveChats withDates(Iterable<Integer> elements) {
        if (this.dates == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableInactiveChats.createUnmodifiableList(false, ImmutableInactiveChats.createSafeList(elements, true, false));
        return new ImmutableInactiveChats(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableInactiveChats withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableInactiveChats.createUnmodifiableList(false, ImmutableInactiveChats.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInactiveChats(this.identifier, this.dates, newValue, this.users);
    }

    public final ImmutableInactiveChats withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableInactiveChats.createUnmodifiableList(false, ImmutableInactiveChats.createSafeList(elements, true, false));
        return new ImmutableInactiveChats(this.identifier, this.dates, newValue, this.users);
    }

    public final ImmutableInactiveChats withUsers(User ... elements) {
        List<User> newValue = ImmutableInactiveChats.createUnmodifiableList(false, ImmutableInactiveChats.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInactiveChats(this.identifier, this.dates, this.chats, newValue);
    }

    public final ImmutableInactiveChats withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableInactiveChats.createUnmodifiableList(false, ImmutableInactiveChats.createSafeList(elements, true, false));
        return new ImmutableInactiveChats(this.identifier, this.dates, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInactiveChats && this.equalTo(0, (ImmutableInactiveChats)another);
    }

    private boolean equalTo(int synthetic, ImmutableInactiveChats another) {
        return this.identifier == another.identifier && this.dates.equals(another.dates) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.dates.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "InactiveChats{identifier=" + this.identifier + ", dates=" + this.dates + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableInactiveChats copyOf(InactiveChats instance) {
        if (instance instanceof ImmutableInactiveChats) {
            return (ImmutableInactiveChats)instance;
        }
        return ImmutableInactiveChats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Integer> dates = new ArrayList<Integer>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(InactiveChats instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InactiveChats instance;
            long bits = 0L;
            if (object instanceof InactiveChats) {
                instance = (InactiveChats)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllDates(instance.dates());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addDate(int element) {
            this.dates.add(element);
            return this;
        }

        public final Builder addDates(int ... elements) {
            for (int element : elements) {
                this.dates.add(element);
            }
            return this;
        }

        public final Builder dates(Iterable<Integer> elements) {
            this.dates.clear();
            return this.addAllDates(elements);
        }

        public final Builder addAllDates(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.dates.add(Objects.requireNonNull(element, "dates element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableInactiveChats build() {
            return new ImmutableInactiveChats(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

