/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.MessageEditData;

public final class ImmutableMessageEditData
implements MessageEditData {
    private final int identifier;
    private final int flags;
    private final boolean caption;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableMessageEditData INSTANCE = ImmutableMessageEditData.validate(new ImmutableMessageEditData());

    private ImmutableMessageEditData() {
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.caption = this.initShim.caption();
        this.initShim = null;
    }

    private ImmutableMessageEditData(Builder builder) {
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.captionIsSet()) {
            this.initShim.caption(builder.caption);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.caption = this.initShim.caption();
        this.initShim = null;
    }

    private ImmutableMessageEditData(int identifier, int flags, boolean caption) {
        this.identifier = identifier;
        this.flags = flags;
        this.caption = caption;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageEditData.super.identifier();
    }

    private int flagsInitialize() {
        return MessageEditData.super.flags();
    }

    private boolean captionInitialize() {
        return MessageEditData.super.caption();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean caption() {
        InitShim shim = this.initShim;
        return shim != null ? shim.caption() : this.caption;
    }

    public final ImmutableMessageEditData withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableMessageEditData.validate(new ImmutableMessageEditData(value, this.flags, this.caption));
    }

    public final ImmutableMessageEditData withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableMessageEditData.validate(new ImmutableMessageEditData(this.identifier, value, this.caption));
    }

    public final ImmutableMessageEditData withCaption(boolean value) {
        if (this.caption == value) {
            return this;
        }
        return ImmutableMessageEditData.validate(new ImmutableMessageEditData(this.identifier, this.flags, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageEditData && this.equalTo(0, (ImmutableMessageEditData)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageEditData another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.caption == another.caption;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.caption);
        return h;
    }

    public String toString() {
        return "MessageEditData{identifier=" + this.identifier + ", flags=" + this.flags + ", caption=" + this.caption + "}";
    }

    public static ImmutableMessageEditData of() {
        return INSTANCE;
    }

    private static ImmutableMessageEditData validate(ImmutableMessageEditData instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableMessageEditData copyOf(MessageEditData instance) {
        if (instance instanceof ImmutableMessageEditData) {
            return (ImmutableMessageEditData)instance;
        }
        return ImmutableMessageEditData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CAPTION = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean caption;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageEditData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageEditData) {
                instance = (MessageEditData)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.caption(instance.caption());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder caption(boolean caption) {
            this.caption = caption;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableMessageEditData build() {
            return ImmutableMessageEditData.validate(new ImmutableMessageEditData(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean captionIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte captionBuildStage = 0;
        private boolean caption;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageEditData.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageEditData.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean caption() {
            if (this.captionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.captionBuildStage == 0) {
                this.captionBuildStage = (byte)-1;
                this.caption = ImmutableMessageEditData.this.captionInitialize();
                this.captionBuildStage = 1;
            }
            return this.caption;
        }

        void caption(boolean caption) {
            this.caption = caption;
            this.captionBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.captionBuildStage == -1) {
                attributes.add("caption");
            }
            return "Cannot build MessageEditData, attribute initializers form cycle " + attributes;
        }
    }
}

