/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Chat;
import telegram4j.tl.MessagePeerReaction;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.MessageReactionsList;

public final class ImmutableMessageReactionsList
implements MessageReactionsList {
    private final int identifier;
    private final int flags;
    private final int count;
    private final List<MessagePeerReaction> reactions;
    private final List<Chat> chats;
    private final List<User> users;
    @Nullable
    private final String nextOffset;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageReactionsList(int count) {
        this.count = count;
        this.reactions = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.nextOffset = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageReactionsList(Builder builder) {
        this.count = builder.count;
        this.reactions = ImmutableMessageReactionsList.createUnmodifiableList(true, builder.reactions);
        this.chats = ImmutableMessageReactionsList.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableMessageReactionsList.createUnmodifiableList(true, builder.users);
        this.nextOffset = builder.nextOffset;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableMessageReactionsList(int identifier, int flags, int count, List<MessagePeerReaction> reactions, List<Chat> chats, List<User> users, @Nullable String nextOffset) {
        this.identifier = identifier;
        this.flags = flags;
        this.count = count;
        this.reactions = reactions;
        this.chats = chats;
        this.users = users;
        this.nextOffset = nextOffset;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessageReactionsList.super.identifier();
    }

    private int flagsInitialize() {
        return MessageReactionsList.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<MessagePeerReaction> reactions() {
        return this.reactions;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    @Override
    @Nullable
    public String nextOffset() {
        return this.nextOffset;
    }

    public final ImmutableMessageReactionsList withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageReactionsList(value, this.flags, this.count, this.reactions, this.chats, this.users, this.nextOffset);
    }

    public final ImmutableMessageReactionsList withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessageReactionsList(this.identifier, value, this.count, this.reactions, this.chats, this.users, this.nextOffset);
    }

    public final ImmutableMessageReactionsList withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableMessageReactionsList(this.identifier, this.flags, value, this.reactions, this.chats, this.users, this.nextOffset);
    }

    public final ImmutableMessageReactionsList withReactions(MessagePeerReaction ... elements) {
        List<MessagePeerReaction> newValue = ImmutableMessageReactionsList.createUnmodifiableList(false, ImmutableMessageReactionsList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageReactionsList(this.identifier, this.flags, this.count, newValue, this.chats, this.users, this.nextOffset);
    }

    public final ImmutableMessageReactionsList withReactions(Iterable<? extends MessagePeerReaction> elements) {
        if (this.reactions == elements) {
            return this;
        }
        List<MessagePeerReaction> newValue = ImmutableMessageReactionsList.createUnmodifiableList(false, ImmutableMessageReactionsList.createSafeList(elements, true, false));
        return new ImmutableMessageReactionsList(this.identifier, this.flags, this.count, newValue, this.chats, this.users, this.nextOffset);
    }

    public final ImmutableMessageReactionsList withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableMessageReactionsList.createUnmodifiableList(false, ImmutableMessageReactionsList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageReactionsList(this.identifier, this.flags, this.count, this.reactions, newValue, this.users, this.nextOffset);
    }

    public final ImmutableMessageReactionsList withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableMessageReactionsList.createUnmodifiableList(false, ImmutableMessageReactionsList.createSafeList(elements, true, false));
        return new ImmutableMessageReactionsList(this.identifier, this.flags, this.count, this.reactions, newValue, this.users, this.nextOffset);
    }

    public final ImmutableMessageReactionsList withUsers(User ... elements) {
        List<User> newValue = ImmutableMessageReactionsList.createUnmodifiableList(false, ImmutableMessageReactionsList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageReactionsList(this.identifier, this.flags, this.count, this.reactions, this.chats, newValue, this.nextOffset);
    }

    public final ImmutableMessageReactionsList withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableMessageReactionsList.createUnmodifiableList(false, ImmutableMessageReactionsList.createSafeList(elements, true, false));
        return new ImmutableMessageReactionsList(this.identifier, this.flags, this.count, this.reactions, this.chats, newValue, this.nextOffset);
    }

    public final ImmutableMessageReactionsList withNextOffset(@Nullable String value) {
        if (Objects.equals(this.nextOffset, value)) {
            return this;
        }
        return new ImmutableMessageReactionsList(this.identifier, this.flags, this.count, this.reactions, this.chats, this.users, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageReactionsList && this.equalTo(0, (ImmutableMessageReactionsList)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageReactionsList another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.count == another.count && this.reactions.equals(another.reactions) && this.chats.equals(another.chats) && this.users.equals(another.users) && Objects.equals(this.nextOffset, another.nextOffset);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.count;
        h += (h << 5) + this.reactions.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        h += (h << 5) + Objects.hashCode(this.nextOffset);
        return h;
    }

    public String toString() {
        return "MessageReactionsList{identifier=" + this.identifier + ", flags=" + this.flags + ", count=" + this.count + ", reactions=" + this.reactions + ", chats=" + this.chats + ", users=" + this.users + ", nextOffset=" + this.nextOffset + "}";
    }

    public static ImmutableMessageReactionsList of(int count) {
        return new ImmutableMessageReactionsList(count);
    }

    public static ImmutableMessageReactionsList copyOf(MessageReactionsList instance) {
        if (instance instanceof ImmutableMessageReactionsList) {
            return (ImmutableMessageReactionsList)instance;
        }
        return ImmutableMessageReactionsList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private int count;
        private List<MessagePeerReaction> reactions = new ArrayList<MessagePeerReaction>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();
        private String nextOffset;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageReactionsList instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageReactionsList) {
                instance = (MessageReactionsList)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.flags(instance.flags());
                this.count(instance.count());
                this.addAllChats(instance.chats());
                this.addAllReactions(instance.reactions());
                String nextOffsetValue = instance.nextOffset();
                if (nextOffsetValue != null) {
                    this.nextOffset(nextOffsetValue);
                }
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addReaction(MessagePeerReaction element) {
            this.reactions.add(Objects.requireNonNull(element, "reactions element"));
            return this;
        }

        public final Builder addReactions(MessagePeerReaction ... elements) {
            for (MessagePeerReaction element : elements) {
                this.reactions.add(Objects.requireNonNull(element, "reactions element"));
            }
            return this;
        }

        public final Builder reactions(Iterable<? extends MessagePeerReaction> elements) {
            this.reactions.clear();
            return this.addAllReactions(elements);
        }

        public final Builder addAllReactions(Iterable<? extends MessagePeerReaction> elements) {
            for (MessagePeerReaction messagePeerReaction : elements) {
                this.reactions.add(Objects.requireNonNull(messagePeerReaction, "reactions element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public final Builder nextOffset(@Nullable String nextOffset) {
            this.nextOffset = nextOffset;
            return this;
        }

        public ImmutableMessageReactionsList build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageReactionsList(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build MessageReactionsList, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessageReactionsList.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessageReactionsList.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build MessageReactionsList, attribute initializers form cycle " + attributes;
        }
    }
}

