/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.MessageViews;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;

public final class ImmutableMessageViews
implements telegram4j.tl.messages.MessageViews {
    private final int identifier;
    private final List<MessageViews> views;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableMessageViews(Builder builder) {
        this.views = ImmutableMessageViews.createUnmodifiableList(true, builder.views);
        this.chats = ImmutableMessageViews.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableMessageViews.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : telegram4j.tl.messages.MessageViews.super.identifier();
    }

    private ImmutableMessageViews(int identifier, List<MessageViews> views, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.views = views;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<MessageViews> views() {
        return this.views;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableMessageViews withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageViews(value, this.views, this.chats, this.users);
    }

    public final ImmutableMessageViews withViews(MessageViews ... elements) {
        List<MessageViews> newValue = ImmutableMessageViews.createUnmodifiableList(false, ImmutableMessageViews.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageViews(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableMessageViews withViews(Iterable<? extends MessageViews> elements) {
        if (this.views == elements) {
            return this;
        }
        List<MessageViews> newValue = ImmutableMessageViews.createUnmodifiableList(false, ImmutableMessageViews.createSafeList(elements, true, false));
        return new ImmutableMessageViews(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableMessageViews withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableMessageViews.createUnmodifiableList(false, ImmutableMessageViews.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageViews(this.identifier, this.views, newValue, this.users);
    }

    public final ImmutableMessageViews withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableMessageViews.createUnmodifiableList(false, ImmutableMessageViews.createSafeList(elements, true, false));
        return new ImmutableMessageViews(this.identifier, this.views, newValue, this.users);
    }

    public final ImmutableMessageViews withUsers(User ... elements) {
        List<User> newValue = ImmutableMessageViews.createUnmodifiableList(false, ImmutableMessageViews.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageViews(this.identifier, this.views, this.chats, newValue);
    }

    public final ImmutableMessageViews withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableMessageViews.createUnmodifiableList(false, ImmutableMessageViews.createSafeList(elements, true, false));
        return new ImmutableMessageViews(this.identifier, this.views, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageViews && this.equalTo(0, (ImmutableMessageViews)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageViews another) {
        return this.identifier == another.identifier && this.views.equals(another.views) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.views.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "MessageViews{identifier=" + this.identifier + ", views=" + this.views + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableMessageViews copyOf(telegram4j.tl.messages.MessageViews instance) {
        if (instance instanceof ImmutableMessageViews) {
            return (ImmutableMessageViews)instance;
        }
        return ImmutableMessageViews.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<MessageViews> views = new ArrayList<MessageViews>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(telegram4j.tl.messages.MessageViews instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof telegram4j.tl.messages.MessageViews) {
                instance = (telegram4j.tl.messages.MessageViews)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllViews(instance.views());
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addView(MessageViews element) {
            this.views.add(Objects.requireNonNull(element, "views element"));
            return this;
        }

        public final Builder addViews(MessageViews ... elements) {
            for (MessageViews element : elements) {
                this.views.add(Objects.requireNonNull(element, "views element"));
            }
            return this;
        }

        public final Builder views(Iterable<? extends MessageViews> elements) {
            this.views.clear();
            return this.addAllViews(elements);
        }

        public final Builder addAllViews(Iterable<? extends MessageViews> elements) {
            for (MessageViews messageViews : elements) {
                this.views.add(Objects.requireNonNull(messageViews, "views element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableMessageViews build() {
            return new ImmutableMessageViews(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

