/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.Messages;
import telegram4j.tl.messages.MessagesNotModified;

public final class ImmutableMessagesNotModified
implements MessagesNotModified {
    private final int identifier;
    private final int count;

    private ImmutableMessagesNotModified(int count) {
        this.count = count;
        this.identifier = MessagesNotModified.super.identifier();
    }

    private ImmutableMessagesNotModified(Builder builder) {
        this.count = builder.count;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessagesNotModified.super.identifier();
    }

    private ImmutableMessagesNotModified(int identifier, int count) {
        this.identifier = identifier;
        this.count = count;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int count() {
        return this.count;
    }

    public final ImmutableMessagesNotModified withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessagesNotModified(value, this.count);
    }

    public final ImmutableMessagesNotModified withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableMessagesNotModified(this.identifier, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessagesNotModified && this.equalTo(0, (ImmutableMessagesNotModified)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessagesNotModified another) {
        return this.identifier == another.identifier && this.count == another.count;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.count;
        return h;
    }

    public String toString() {
        return "MessagesNotModified{identifier=" + this.identifier + ", count=" + this.count + "}";
    }

    public static ImmutableMessagesNotModified of(int count) {
        return new ImmutableMessagesNotModified(count);
    }

    public static ImmutableMessagesNotModified copyOf(MessagesNotModified instance) {
        if (instance instanceof ImmutableMessagesNotModified) {
            return (ImmutableMessagesNotModified)instance;
        }
        return ImmutableMessagesNotModified.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int count;

        private Builder() {
        }

        public final Builder from(MessagesNotModified instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Messages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Messages instance;
            long bits = 0L;
            if (object instanceof MessagesNotModified) {
                instance = (MessagesNotModified)object;
                this.count(instance.count());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Messages) {
                instance = (Messages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessagesNotModified build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessagesNotModified(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build MessagesNotModified, some of required attributes are not set " + attributes;
        }
    }
}

