/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Chat;
import telegram4j.tl.Message;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.Messages;
import telegram4j.tl.messages.MessagesSlice;

public final class ImmutableMessagesSlice
implements MessagesSlice {
    private final int identifier;
    private final int flags;
    private final boolean inexact;
    private final int count;
    @Nullable
    private final Integer nextRate;
    @Nullable
    private final Integer offsetIdOffset;
    private final List<Message> messages;
    private final List<Chat> chats;
    private final List<User> users;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessagesSlice(int count) {
        this.count = count;
        this.nextRate = null;
        this.offsetIdOffset = null;
        this.messages = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inexact = this.initShim.inexact();
        this.initShim = null;
    }

    private ImmutableMessagesSlice(Builder builder) {
        this.count = builder.count;
        this.nextRate = builder.nextRate;
        this.offsetIdOffset = builder.offsetIdOffset;
        this.messages = ImmutableMessagesSlice.createUnmodifiableList(true, builder.messages);
        this.chats = ImmutableMessagesSlice.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableMessagesSlice.createUnmodifiableList(true, builder.users);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.inexactIsSet()) {
            this.initShim.inexact(builder.inexact);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inexact = this.initShim.inexact();
        this.initShim = null;
    }

    private ImmutableMessagesSlice(int identifier, int flags, boolean inexact, int count, @Nullable Integer nextRate, @Nullable Integer offsetIdOffset, List<Message> messages, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.flags = flags;
        this.inexact = inexact;
        this.count = count;
        this.nextRate = nextRate;
        this.offsetIdOffset = offsetIdOffset;
        this.messages = messages;
        this.chats = chats;
        this.users = users;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MessagesSlice.super.identifier();
    }

    private int flagsInitialize() {
        return MessagesSlice.super.flags();
    }

    private boolean inexactInitialize() {
        return MessagesSlice.super.inexact();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean inexact() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inexact() : this.inexact;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    @Nullable
    public Integer nextRate() {
        return this.nextRate;
    }

    @Override
    @Nullable
    public Integer offsetIdOffset() {
        return this.offsetIdOffset;
    }

    @Override
    public List<Message> messages() {
        return this.messages;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableMessagesSlice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessagesSlice(value, this.flags, this.inexact, this.count, this.nextRate, this.offsetIdOffset, this.messages, this.chats, this.users);
    }

    public final ImmutableMessagesSlice withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableMessagesSlice(this.identifier, value, this.inexact, this.count, this.nextRate, this.offsetIdOffset, this.messages, this.chats, this.users);
    }

    public final ImmutableMessagesSlice withInexact(boolean value) {
        if (this.inexact == value) {
            return this;
        }
        return new ImmutableMessagesSlice(this.identifier, this.flags, value, this.count, this.nextRate, this.offsetIdOffset, this.messages, this.chats, this.users);
    }

    public final ImmutableMessagesSlice withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableMessagesSlice(this.identifier, this.flags, this.inexact, value, this.nextRate, this.offsetIdOffset, this.messages, this.chats, this.users);
    }

    public final ImmutableMessagesSlice withNextRate(@Nullable Integer value) {
        if (Objects.equals(this.nextRate, value)) {
            return this;
        }
        return new ImmutableMessagesSlice(this.identifier, this.flags, this.inexact, this.count, value, this.offsetIdOffset, this.messages, this.chats, this.users);
    }

    public final ImmutableMessagesSlice withOffsetIdOffset(@Nullable Integer value) {
        if (Objects.equals(this.offsetIdOffset, value)) {
            return this;
        }
        return new ImmutableMessagesSlice(this.identifier, this.flags, this.inexact, this.count, this.nextRate, value, this.messages, this.chats, this.users);
    }

    public final ImmutableMessagesSlice withMessages(Message ... elements) {
        List<Message> newValue = ImmutableMessagesSlice.createUnmodifiableList(false, ImmutableMessagesSlice.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessagesSlice(this.identifier, this.flags, this.inexact, this.count, this.nextRate, this.offsetIdOffset, newValue, this.chats, this.users);
    }

    public final ImmutableMessagesSlice withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Message> newValue = ImmutableMessagesSlice.createUnmodifiableList(false, ImmutableMessagesSlice.createSafeList(elements, true, false));
        return new ImmutableMessagesSlice(this.identifier, this.flags, this.inexact, this.count, this.nextRate, this.offsetIdOffset, newValue, this.chats, this.users);
    }

    public final ImmutableMessagesSlice withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableMessagesSlice.createUnmodifiableList(false, ImmutableMessagesSlice.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessagesSlice(this.identifier, this.flags, this.inexact, this.count, this.nextRate, this.offsetIdOffset, this.messages, newValue, this.users);
    }

    public final ImmutableMessagesSlice withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableMessagesSlice.createUnmodifiableList(false, ImmutableMessagesSlice.createSafeList(elements, true, false));
        return new ImmutableMessagesSlice(this.identifier, this.flags, this.inexact, this.count, this.nextRate, this.offsetIdOffset, this.messages, newValue, this.users);
    }

    public final ImmutableMessagesSlice withUsers(User ... elements) {
        List<User> newValue = ImmutableMessagesSlice.createUnmodifiableList(false, ImmutableMessagesSlice.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessagesSlice(this.identifier, this.flags, this.inexact, this.count, this.nextRate, this.offsetIdOffset, this.messages, this.chats, newValue);
    }

    public final ImmutableMessagesSlice withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableMessagesSlice.createUnmodifiableList(false, ImmutableMessagesSlice.createSafeList(elements, true, false));
        return new ImmutableMessagesSlice(this.identifier, this.flags, this.inexact, this.count, this.nextRate, this.offsetIdOffset, this.messages, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessagesSlice && this.equalTo(0, (ImmutableMessagesSlice)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessagesSlice another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.inexact == another.inexact && this.count == another.count && Objects.equals(this.nextRate, another.nextRate) && Objects.equals(this.offsetIdOffset, another.offsetIdOffset) && this.messages.equals(another.messages) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.inexact);
        h += (h << 5) + this.count;
        h += (h << 5) + Objects.hashCode(this.nextRate);
        h += (h << 5) + Objects.hashCode(this.offsetIdOffset);
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "MessagesSlice{identifier=" + this.identifier + ", flags=" + this.flags + ", inexact=" + this.inexact + ", count=" + this.count + ", nextRate=" + this.nextRate + ", offsetIdOffset=" + this.offsetIdOffset + ", messages=" + this.messages + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableMessagesSlice of(int count) {
        return new ImmutableMessagesSlice(count);
    }

    public static ImmutableMessagesSlice copyOf(MessagesSlice instance) {
        if (instance instanceof ImmutableMessagesSlice) {
            return (ImmutableMessagesSlice)instance;
        }
        return ImmutableMessagesSlice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_INEXACT = 4L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean inexact;
        private int count;
        private Integer nextRate;
        private Integer offsetIdOffset;
        private List<Message> messages = new ArrayList<Message>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Messages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessagesSlice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Messages) {
                instance = (Messages)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessagesSlice) {
                Integer nextRateValue;
                Integer offsetIdOffsetValue;
                instance = (MessagesSlice)object;
                this.inexact(instance.inexact());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((offsetIdOffsetValue = instance.offsetIdOffset()) != null) {
                    this.offsetIdOffset(offsetIdOffsetValue);
                }
                if ((nextRateValue = instance.nextRate()) != null) {
                    this.nextRate(nextRateValue);
                }
                this.flags(instance.flags());
                this.count(instance.count());
                this.addAllChats(instance.chats());
                this.addAllMessages(instance.messages());
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder inexact(boolean inexact) {
            this.inexact = inexact;
            this.optBits |= 4L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder nextRate(@Nullable Integer nextRate) {
            this.nextRate = nextRate;
            return this;
        }

        public final Builder offsetIdOffset(@Nullable Integer offsetIdOffset) {
            this.offsetIdOffset = offsetIdOffset;
            return this;
        }

        public final Builder addMessage(Message element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(Message ... elements) {
            for (Message element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            for (Message message : elements) {
                this.messages.add(Objects.requireNonNull(message, "messages element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableMessagesSlice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessagesSlice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean inexactIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build MessagesSlice, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte inexactBuildStage = 0;
        private boolean inexact;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMessagesSlice.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableMessagesSlice.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean inexact() {
            if (this.inexactBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inexactBuildStage == 0) {
                this.inexactBuildStage = (byte)-1;
                this.inexact = ImmutableMessagesSlice.this.inexactInitialize();
                this.inexactBuildStage = 1;
            }
            return this.inexact;
        }

        void inexact(boolean inexact) {
            this.inexact = inexact;
            this.inexactBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.inexactBuildStage == -1) {
                attributes.add("inexact");
            }
            return "Cannot build MessagesSlice, attribute initializers form cycle " + attributes;
        }
    }
}

