/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.PeerSettings;

public final class ImmutablePeerSettings
implements PeerSettings {
    private final int identifier;
    private final telegram4j.tl.PeerSettings settings;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutablePeerSettings(telegram4j.tl.PeerSettings settings) {
        this.settings = Objects.requireNonNull(settings, "settings");
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = PeerSettings.super.identifier();
    }

    private ImmutablePeerSettings(Builder builder) {
        this.settings = builder.settings;
        this.chats = ImmutablePeerSettings.createUnmodifiableList(true, builder.chats);
        this.users = ImmutablePeerSettings.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : PeerSettings.super.identifier();
    }

    private ImmutablePeerSettings(int identifier, telegram4j.tl.PeerSettings settings, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.settings = settings;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public telegram4j.tl.PeerSettings settings() {
        return this.settings;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutablePeerSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePeerSettings(value, this.settings, this.chats, this.users);
    }

    public final ImmutablePeerSettings withSettings(telegram4j.tl.PeerSettings value) {
        if (this.settings == value) {
            return this;
        }
        telegram4j.tl.PeerSettings newValue = Objects.requireNonNull(value, "settings");
        return new ImmutablePeerSettings(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutablePeerSettings withChats(Chat ... elements) {
        List<Chat> newValue = ImmutablePeerSettings.createUnmodifiableList(false, ImmutablePeerSettings.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePeerSettings(this.identifier, this.settings, newValue, this.users);
    }

    public final ImmutablePeerSettings withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutablePeerSettings.createUnmodifiableList(false, ImmutablePeerSettings.createSafeList(elements, true, false));
        return new ImmutablePeerSettings(this.identifier, this.settings, newValue, this.users);
    }

    public final ImmutablePeerSettings withUsers(User ... elements) {
        List<User> newValue = ImmutablePeerSettings.createUnmodifiableList(false, ImmutablePeerSettings.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePeerSettings(this.identifier, this.settings, this.chats, newValue);
    }

    public final ImmutablePeerSettings withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutablePeerSettings.createUnmodifiableList(false, ImmutablePeerSettings.createSafeList(elements, true, false));
        return new ImmutablePeerSettings(this.identifier, this.settings, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePeerSettings && this.equalTo(0, (ImmutablePeerSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutablePeerSettings another) {
        return this.identifier == another.identifier && this.settings.equals(another.settings) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.settings.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "PeerSettings{identifier=" + this.identifier + ", settings=" + this.settings + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutablePeerSettings of(telegram4j.tl.PeerSettings settings) {
        return new ImmutablePeerSettings(settings);
    }

    public static ImmutablePeerSettings copyOf(PeerSettings instance) {
        if (instance instanceof ImmutablePeerSettings) {
            return (ImmutablePeerSettings)instance;
        }
        return ImmutablePeerSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SETTINGS = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private telegram4j.tl.PeerSettings settings;
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(PeerSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PeerSettings instance;
            long bits = 0L;
            if (object instanceof PeerSettings) {
                instance = (PeerSettings)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.settings(instance.settings());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder settings(telegram4j.tl.PeerSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutablePeerSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePeerSettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("settings");
            }
            return "Cannot build PeerSettings, some of required attributes are not set " + attributes;
        }
    }
}

