/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessagesFilter;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.SearchCounter;

public final class ImmutableSearchCounter
implements SearchCounter {
    private final int identifier;
    private final int flags;
    private final boolean inexact;
    private final MessagesFilter filter;
    private final int count;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSearchCounter(MessagesFilter filter, int count) {
        this.filter = Objects.requireNonNull(filter, "filter");
        this.count = count;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inexact = this.initShim.inexact();
        this.initShim = null;
    }

    private ImmutableSearchCounter(Builder builder) {
        this.filter = builder.filter;
        this.count = builder.count;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.inexactIsSet()) {
            this.initShim.inexact(builder.inexact);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inexact = this.initShim.inexact();
        this.initShim = null;
    }

    private ImmutableSearchCounter(int identifier, int flags, boolean inexact, MessagesFilter filter, int count) {
        this.identifier = identifier;
        this.flags = flags;
        this.inexact = inexact;
        this.filter = filter;
        this.count = count;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SearchCounter.super.identifier();
    }

    private int flagsInitialize() {
        return SearchCounter.super.flags();
    }

    private boolean inexactInitialize() {
        return SearchCounter.super.inexact();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean inexact() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inexact() : this.inexact;
    }

    @Override
    public MessagesFilter filter() {
        return this.filter;
    }

    @Override
    public int count() {
        return this.count;
    }

    public final ImmutableSearchCounter withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSearchCounter(value, this.flags, this.inexact, this.filter, this.count);
    }

    public final ImmutableSearchCounter withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSearchCounter(this.identifier, value, this.inexact, this.filter, this.count);
    }

    public final ImmutableSearchCounter withInexact(boolean value) {
        if (this.inexact == value) {
            return this;
        }
        return new ImmutableSearchCounter(this.identifier, this.flags, value, this.filter, this.count);
    }

    public final ImmutableSearchCounter withFilter(MessagesFilter value) {
        if (this.filter == value) {
            return this;
        }
        MessagesFilter newValue = Objects.requireNonNull(value, "filter");
        return new ImmutableSearchCounter(this.identifier, this.flags, this.inexact, newValue, this.count);
    }

    public final ImmutableSearchCounter withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableSearchCounter(this.identifier, this.flags, this.inexact, this.filter, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchCounter && this.equalTo(0, (ImmutableSearchCounter)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchCounter another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.inexact == another.inexact && this.filter.equals(another.filter) && this.count == another.count;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.inexact);
        h += (h << 5) + this.filter.hashCode();
        h += (h << 5) + this.count;
        return h;
    }

    public String toString() {
        return "SearchCounter{identifier=" + this.identifier + ", flags=" + this.flags + ", inexact=" + this.inexact + ", filter=" + this.filter + ", count=" + this.count + "}";
    }

    public static ImmutableSearchCounter of(MessagesFilter filter, int count) {
        return new ImmutableSearchCounter(filter, count);
    }

    public static ImmutableSearchCounter copyOf(SearchCounter instance) {
        if (instance instanceof ImmutableSearchCounter) {
            return (ImmutableSearchCounter)instance;
        }
        return ImmutableSearchCounter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FILTER = 1L;
        private static final long INIT_BIT_COUNT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_INEXACT = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean inexact;
        private MessagesFilter filter;
        private int count;

        private Builder() {
        }

        public final Builder from(SearchCounter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SearchCounter instance;
            long bits = 0L;
            if (object instanceof SearchCounter) {
                instance = (SearchCounter)object;
                this.inexact(instance.inexact());
                this.filter(instance.filter());
                this.flags(instance.flags());
                this.count(instance.count());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder inexact(boolean inexact) {
            this.inexact = inexact;
            this.optBits |= 4L;
            return this;
        }

        public final Builder filter(MessagesFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSearchCounter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSearchCounter(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean inexactIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("filter");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build SearchCounter, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte inexactBuildStage = 0;
        private boolean inexact;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSearchCounter.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSearchCounter.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean inexact() {
            if (this.inexactBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inexactBuildStage == 0) {
                this.inexactBuildStage = (byte)-1;
                this.inexact = ImmutableSearchCounter.this.inexactInitialize();
                this.inexactBuildStage = 1;
            }
            return this.inexact;
        }

        void inexact(boolean inexact) {
            this.inexact = inexact;
            this.inexactBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.inexactBuildStage == -1) {
                attributes.add("inexact");
            }
            return "Cannot build SearchCounter, attribute initializers form cycle " + attributes;
        }
    }
}

