/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Chat;
import telegram4j.tl.Message;
import telegram4j.tl.SearchResultsCalendarPeriod;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.SearchResultsCalendar;

public final class ImmutableSearchResultsCalendar
implements SearchResultsCalendar {
    private final int identifier;
    private final int flags;
    private final boolean inexact;
    private final int count;
    private final int minDate;
    private final int minMsgId;
    @Nullable
    private final Integer offsetIdOffset;
    private final List<SearchResultsCalendarPeriod> periods;
    private final List<Message> messages;
    private final List<Chat> chats;
    private final List<User> users;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSearchResultsCalendar(int count, int minDate, int minMsgId) {
        this.count = count;
        this.minDate = minDate;
        this.minMsgId = minMsgId;
        this.offsetIdOffset = null;
        this.periods = Collections.emptyList();
        this.messages = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inexact = this.initShim.inexact();
        this.initShim = null;
    }

    private ImmutableSearchResultsCalendar(Builder builder) {
        this.count = builder.count;
        this.minDate = builder.minDate;
        this.minMsgId = builder.minMsgId;
        this.offsetIdOffset = builder.offsetIdOffset;
        this.periods = ImmutableSearchResultsCalendar.createUnmodifiableList(true, builder.periods);
        this.messages = ImmutableSearchResultsCalendar.createUnmodifiableList(true, builder.messages);
        this.chats = ImmutableSearchResultsCalendar.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableSearchResultsCalendar.createUnmodifiableList(true, builder.users);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.inexactIsSet()) {
            this.initShim.inexact(builder.inexact);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.inexact = this.initShim.inexact();
        this.initShim = null;
    }

    private ImmutableSearchResultsCalendar(int identifier, int flags, boolean inexact, int count, int minDate, int minMsgId, @Nullable Integer offsetIdOffset, List<SearchResultsCalendarPeriod> periods, List<Message> messages, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.flags = flags;
        this.inexact = inexact;
        this.count = count;
        this.minDate = minDate;
        this.minMsgId = minMsgId;
        this.offsetIdOffset = offsetIdOffset;
        this.periods = periods;
        this.messages = messages;
        this.chats = chats;
        this.users = users;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SearchResultsCalendar.super.identifier();
    }

    private int flagsInitialize() {
        return SearchResultsCalendar.super.flags();
    }

    private boolean inexactInitialize() {
        return SearchResultsCalendar.super.inexact();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean inexact() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inexact() : this.inexact;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public int minDate() {
        return this.minDate;
    }

    @Override
    public int minMsgId() {
        return this.minMsgId;
    }

    @Override
    @Nullable
    public Integer offsetIdOffset() {
        return this.offsetIdOffset;
    }

    @Override
    public List<SearchResultsCalendarPeriod> periods() {
        return this.periods;
    }

    @Override
    public List<Message> messages() {
        return this.messages;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableSearchResultsCalendar withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSearchResultsCalendar(value, this.flags, this.inexact, this.count, this.minDate, this.minMsgId, this.offsetIdOffset, this.periods, this.messages, this.chats, this.users);
    }

    public final ImmutableSearchResultsCalendar withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSearchResultsCalendar(this.identifier, value, this.inexact, this.count, this.minDate, this.minMsgId, this.offsetIdOffset, this.periods, this.messages, this.chats, this.users);
    }

    public final ImmutableSearchResultsCalendar withInexact(boolean value) {
        if (this.inexact == value) {
            return this;
        }
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, value, this.count, this.minDate, this.minMsgId, this.offsetIdOffset, this.periods, this.messages, this.chats, this.users);
    }

    public final ImmutableSearchResultsCalendar withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, value, this.minDate, this.minMsgId, this.offsetIdOffset, this.periods, this.messages, this.chats, this.users);
    }

    public final ImmutableSearchResultsCalendar withMinDate(int value) {
        if (this.minDate == value) {
            return this;
        }
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, this.count, value, this.minMsgId, this.offsetIdOffset, this.periods, this.messages, this.chats, this.users);
    }

    public final ImmutableSearchResultsCalendar withMinMsgId(int value) {
        if (this.minMsgId == value) {
            return this;
        }
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, this.count, this.minDate, value, this.offsetIdOffset, this.periods, this.messages, this.chats, this.users);
    }

    public final ImmutableSearchResultsCalendar withOffsetIdOffset(@Nullable Integer value) {
        if (Objects.equals(this.offsetIdOffset, value)) {
            return this;
        }
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, this.count, this.minDate, this.minMsgId, value, this.periods, this.messages, this.chats, this.users);
    }

    public final ImmutableSearchResultsCalendar withPeriods(SearchResultsCalendarPeriod ... elements) {
        List<SearchResultsCalendarPeriod> newValue = ImmutableSearchResultsCalendar.createUnmodifiableList(false, ImmutableSearchResultsCalendar.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, this.count, this.minDate, this.minMsgId, this.offsetIdOffset, newValue, this.messages, this.chats, this.users);
    }

    public final ImmutableSearchResultsCalendar withPeriods(Iterable<? extends SearchResultsCalendarPeriod> elements) {
        if (this.periods == elements) {
            return this;
        }
        List<SearchResultsCalendarPeriod> newValue = ImmutableSearchResultsCalendar.createUnmodifiableList(false, ImmutableSearchResultsCalendar.createSafeList(elements, true, false));
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, this.count, this.minDate, this.minMsgId, this.offsetIdOffset, newValue, this.messages, this.chats, this.users);
    }

    public final ImmutableSearchResultsCalendar withMessages(Message ... elements) {
        List<Message> newValue = ImmutableSearchResultsCalendar.createUnmodifiableList(false, ImmutableSearchResultsCalendar.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, this.count, this.minDate, this.minMsgId, this.offsetIdOffset, this.periods, newValue, this.chats, this.users);
    }

    public final ImmutableSearchResultsCalendar withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Message> newValue = ImmutableSearchResultsCalendar.createUnmodifiableList(false, ImmutableSearchResultsCalendar.createSafeList(elements, true, false));
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, this.count, this.minDate, this.minMsgId, this.offsetIdOffset, this.periods, newValue, this.chats, this.users);
    }

    public final ImmutableSearchResultsCalendar withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableSearchResultsCalendar.createUnmodifiableList(false, ImmutableSearchResultsCalendar.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, this.count, this.minDate, this.minMsgId, this.offsetIdOffset, this.periods, this.messages, newValue, this.users);
    }

    public final ImmutableSearchResultsCalendar withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableSearchResultsCalendar.createUnmodifiableList(false, ImmutableSearchResultsCalendar.createSafeList(elements, true, false));
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, this.count, this.minDate, this.minMsgId, this.offsetIdOffset, this.periods, this.messages, newValue, this.users);
    }

    public final ImmutableSearchResultsCalendar withUsers(User ... elements) {
        List<User> newValue = ImmutableSearchResultsCalendar.createUnmodifiableList(false, ImmutableSearchResultsCalendar.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, this.count, this.minDate, this.minMsgId, this.offsetIdOffset, this.periods, this.messages, this.chats, newValue);
    }

    public final ImmutableSearchResultsCalendar withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableSearchResultsCalendar.createUnmodifiableList(false, ImmutableSearchResultsCalendar.createSafeList(elements, true, false));
        return new ImmutableSearchResultsCalendar(this.identifier, this.flags, this.inexact, this.count, this.minDate, this.minMsgId, this.offsetIdOffset, this.periods, this.messages, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchResultsCalendar && this.equalTo(0, (ImmutableSearchResultsCalendar)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchResultsCalendar another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.inexact == another.inexact && this.count == another.count && this.minDate == another.minDate && this.minMsgId == another.minMsgId && Objects.equals(this.offsetIdOffset, another.offsetIdOffset) && this.periods.equals(another.periods) && this.messages.equals(another.messages) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.inexact);
        h += (h << 5) + this.count;
        h += (h << 5) + this.minDate;
        h += (h << 5) + this.minMsgId;
        h += (h << 5) + Objects.hashCode(this.offsetIdOffset);
        h += (h << 5) + this.periods.hashCode();
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "SearchResultsCalendar{identifier=" + this.identifier + ", flags=" + this.flags + ", inexact=" + this.inexact + ", count=" + this.count + ", minDate=" + this.minDate + ", minMsgId=" + this.minMsgId + ", offsetIdOffset=" + this.offsetIdOffset + ", periods=" + this.periods + ", messages=" + this.messages + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableSearchResultsCalendar of(int count, int minDate, int minMsgId) {
        return new ImmutableSearchResultsCalendar(count, minDate, minMsgId);
    }

    public static ImmutableSearchResultsCalendar copyOf(SearchResultsCalendar instance) {
        if (instance instanceof ImmutableSearchResultsCalendar) {
            return (ImmutableSearchResultsCalendar)instance;
        }
        return ImmutableSearchResultsCalendar.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long INIT_BIT_MIN_DATE = 2L;
        private static final long INIT_BIT_MIN_MSG_ID = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_INEXACT = 4L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean inexact;
        private int count;
        private int minDate;
        private int minMsgId;
        private Integer offsetIdOffset;
        private List<SearchResultsCalendarPeriod> periods = new ArrayList<SearchResultsCalendarPeriod>();
        private List<Message> messages = new ArrayList<Message>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SearchResultsCalendar instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SearchResultsCalendar) {
                Integer offsetIdOffsetValue;
                instance = (SearchResultsCalendar)object;
                this.inexact(instance.inexact());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((offsetIdOffsetValue = instance.offsetIdOffset()) != null) {
                    this.offsetIdOffset(offsetIdOffsetValue);
                }
                this.minDate(instance.minDate());
                this.flags(instance.flags());
                this.count(instance.count());
                this.addAllChats(instance.chats());
                this.addAllPeriods(instance.periods());
                this.addAllMessages(instance.messages());
                this.minMsgId(instance.minMsgId());
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder inexact(boolean inexact) {
            this.inexact = inexact;
            this.optBits |= 4L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder minDate(int minDate) {
            this.minDate = minDate;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder minMsgId(int minMsgId) {
            this.minMsgId = minMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder offsetIdOffset(@Nullable Integer offsetIdOffset) {
            this.offsetIdOffset = offsetIdOffset;
            return this;
        }

        public final Builder addPeriod(SearchResultsCalendarPeriod element) {
            this.periods.add(Objects.requireNonNull(element, "periods element"));
            return this;
        }

        public final Builder addPeriods(SearchResultsCalendarPeriod ... elements) {
            for (SearchResultsCalendarPeriod element : elements) {
                this.periods.add(Objects.requireNonNull(element, "periods element"));
            }
            return this;
        }

        public final Builder periods(Iterable<? extends SearchResultsCalendarPeriod> elements) {
            this.periods.clear();
            return this.addAllPeriods(elements);
        }

        public final Builder addAllPeriods(Iterable<? extends SearchResultsCalendarPeriod> elements) {
            for (SearchResultsCalendarPeriod searchResultsCalendarPeriod : elements) {
                this.periods.add(Objects.requireNonNull(searchResultsCalendarPeriod, "periods element"));
            }
            return this;
        }

        public final Builder addMessage(Message element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(Message ... elements) {
            for (Message element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            for (Message message : elements) {
                this.messages.add(Objects.requireNonNull(message, "messages element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableSearchResultsCalendar build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSearchResultsCalendar(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean inexactIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minDate");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("minMsgId");
            }
            return "Cannot build SearchResultsCalendar, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte inexactBuildStage = 0;
        private boolean inexact;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSearchResultsCalendar.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSearchResultsCalendar.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean inexact() {
            if (this.inexactBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inexactBuildStage == 0) {
                this.inexactBuildStage = (byte)-1;
                this.inexact = ImmutableSearchResultsCalendar.this.inexactInitialize();
                this.inexactBuildStage = 1;
            }
            return this.inexact;
        }

        void inexact(boolean inexact) {
            this.inexact = inexact;
            this.inexactBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.inexactBuildStage == -1) {
                attributes.add("inexact");
            }
            return "Cannot build SearchResultsCalendar, attribute initializers form cycle " + attributes;
        }
    }
}

