/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.SearchResultsPosition;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.SearchResultsPositions;

public final class ImmutableSearchResultsPositions
implements SearchResultsPositions {
    private final int identifier;
    private final int count;
    private final List<SearchResultsPosition> positions;

    private ImmutableSearchResultsPositions(int count) {
        this.count = count;
        this.positions = Collections.emptyList();
        this.identifier = SearchResultsPositions.super.identifier();
    }

    private ImmutableSearchResultsPositions(Builder builder) {
        this.count = builder.count;
        this.positions = ImmutableSearchResultsPositions.createUnmodifiableList(true, builder.positions);
        this.identifier = builder.identifierIsSet() ? builder.identifier : SearchResultsPositions.super.identifier();
    }

    private ImmutableSearchResultsPositions(int identifier, int count, List<SearchResultsPosition> positions) {
        this.identifier = identifier;
        this.count = count;
        this.positions = positions;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<SearchResultsPosition> positions() {
        return this.positions;
    }

    public final ImmutableSearchResultsPositions withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSearchResultsPositions(value, this.count, this.positions);
    }

    public final ImmutableSearchResultsPositions withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableSearchResultsPositions(this.identifier, value, this.positions);
    }

    public final ImmutableSearchResultsPositions withPositions(SearchResultsPosition ... elements) {
        List<SearchResultsPosition> newValue = ImmutableSearchResultsPositions.createUnmodifiableList(false, ImmutableSearchResultsPositions.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSearchResultsPositions(this.identifier, this.count, newValue);
    }

    public final ImmutableSearchResultsPositions withPositions(Iterable<? extends SearchResultsPosition> elements) {
        if (this.positions == elements) {
            return this;
        }
        List<SearchResultsPosition> newValue = ImmutableSearchResultsPositions.createUnmodifiableList(false, ImmutableSearchResultsPositions.createSafeList(elements, true, false));
        return new ImmutableSearchResultsPositions(this.identifier, this.count, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchResultsPositions && this.equalTo(0, (ImmutableSearchResultsPositions)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchResultsPositions another) {
        return this.identifier == another.identifier && this.count == another.count && this.positions.equals(another.positions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.count;
        h += (h << 5) + this.positions.hashCode();
        return h;
    }

    public String toString() {
        return "SearchResultsPositions{identifier=" + this.identifier + ", count=" + this.count + ", positions=" + this.positions + "}";
    }

    public static ImmutableSearchResultsPositions of(int count) {
        return new ImmutableSearchResultsPositions(count);
    }

    public static ImmutableSearchResultsPositions copyOf(SearchResultsPositions instance) {
        if (instance instanceof ImmutableSearchResultsPositions) {
            return (ImmutableSearchResultsPositions)instance;
        }
        return ImmutableSearchResultsPositions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int count;
        private List<SearchResultsPosition> positions = new ArrayList<SearchResultsPosition>();

        private Builder() {
        }

        public final Builder from(SearchResultsPositions instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SearchResultsPositions instance;
            long bits = 0L;
            if (object instanceof SearchResultsPositions) {
                instance = (SearchResultsPositions)object;
                this.count(instance.count());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllPositions(instance.positions());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPosition(SearchResultsPosition element) {
            this.positions.add(Objects.requireNonNull(element, "positions element"));
            return this;
        }

        public final Builder addPositions(SearchResultsPosition ... elements) {
            for (SearchResultsPosition element : elements) {
                this.positions.add(Objects.requireNonNull(element, "positions element"));
            }
            return this;
        }

        public final Builder positions(Iterable<? extends SearchResultsPosition> elements) {
            this.positions.clear();
            return this.addAllPositions(elements);
        }

        public final Builder addAllPositions(Iterable<? extends SearchResultsPosition> elements) {
            for (SearchResultsPosition searchResultsPosition : elements) {
                this.positions.add(Objects.requireNonNull(searchResultsPosition, "positions element"));
            }
            return this;
        }

        public ImmutableSearchResultsPositions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSearchResultsPositions(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build SearchResultsPositions, some of required attributes are not set " + attributes;
        }
    }
}

