/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.EncryptedFile;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.SentEncryptedFile;
import telegram4j.tl.messages.SentEncryptedMessage;

public final class ImmutableSentEncryptedFile
implements SentEncryptedFile {
    private final int identifier;
    private final int date;
    private final EncryptedFile file;

    private ImmutableSentEncryptedFile(int date, EncryptedFile file) {
        this.date = date;
        this.file = Objects.requireNonNull(file, "file");
        this.identifier = SentEncryptedFile.super.identifier();
    }

    private ImmutableSentEncryptedFile(Builder builder) {
        this.date = builder.date;
        this.file = builder.file;
        this.identifier = builder.identifierIsSet() ? builder.identifier : SentEncryptedFile.super.identifier();
    }

    private ImmutableSentEncryptedFile(int identifier, int date, EncryptedFile file) {
        this.identifier = identifier;
        this.date = date;
        this.file = file;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public EncryptedFile file() {
        return this.file;
    }

    public final ImmutableSentEncryptedFile withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSentEncryptedFile(value, this.date, this.file);
    }

    public final ImmutableSentEncryptedFile withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutableSentEncryptedFile(this.identifier, value, this.file);
    }

    public final ImmutableSentEncryptedFile withFile(EncryptedFile value) {
        if (this.file == value) {
            return this;
        }
        EncryptedFile newValue = Objects.requireNonNull(value, "file");
        return new ImmutableSentEncryptedFile(this.identifier, this.date, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSentEncryptedFile && this.equalTo(0, (ImmutableSentEncryptedFile)another);
    }

    private boolean equalTo(int synthetic, ImmutableSentEncryptedFile another) {
        return this.identifier == another.identifier && this.date == another.date && this.file.equals(another.file);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.date;
        h += (h << 5) + this.file.hashCode();
        return h;
    }

    public String toString() {
        return "SentEncryptedFile{identifier=" + this.identifier + ", date=" + this.date + ", file=" + this.file + "}";
    }

    public static ImmutableSentEncryptedFile of(int date, EncryptedFile file) {
        return new ImmutableSentEncryptedFile(date, file);
    }

    public static ImmutableSentEncryptedFile copyOf(SentEncryptedFile instance) {
        if (instance instanceof ImmutableSentEncryptedFile) {
            return (ImmutableSentEncryptedFile)instance;
        }
        return ImmutableSentEncryptedFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long INIT_BIT_FILE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int date;
        private EncryptedFile file;

        private Builder() {
        }

        public final Builder from(SentEncryptedFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SentEncryptedMessage instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SentEncryptedMessage instance;
            long bits = 0L;
            if (object instanceof SentEncryptedFile) {
                instance = (SentEncryptedFile)object;
                if ((bits & 1L) == 0L) {
                    this.date(instance.date());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                this.file(instance.file());
            }
            if (object instanceof SentEncryptedMessage) {
                instance = (SentEncryptedMessage)object;
                if ((bits & 1L) == 0L) {
                    this.date(instance.date());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder file(EncryptedFile file) {
            this.file = Objects.requireNonNull(file, "file");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSentEncryptedFile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSentEncryptedFile(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("file");
            }
            return "Cannot build SentEncryptedFile, some of required attributes are not set " + attributes;
        }
    }
}

