/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.SponsoredMessage;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.SponsoredMessages;

public final class ImmutableSponsoredMessages
implements SponsoredMessages {
    private final int identifier;
    private final List<SponsoredMessage> messages;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableSponsoredMessages(Builder builder) {
        this.messages = ImmutableSponsoredMessages.createUnmodifiableList(true, builder.messages);
        this.chats = ImmutableSponsoredMessages.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableSponsoredMessages.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : SponsoredMessages.super.identifier();
    }

    private ImmutableSponsoredMessages(int identifier, List<SponsoredMessage> messages, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.messages = messages;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<SponsoredMessage> messages() {
        return this.messages;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableSponsoredMessages withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableSponsoredMessages(value, this.messages, this.chats, this.users);
    }

    public final ImmutableSponsoredMessages withMessages(SponsoredMessage ... elements) {
        List<SponsoredMessage> newValue = ImmutableSponsoredMessages.createUnmodifiableList(false, ImmutableSponsoredMessages.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSponsoredMessages(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableSponsoredMessages withMessages(Iterable<? extends SponsoredMessage> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<SponsoredMessage> newValue = ImmutableSponsoredMessages.createUnmodifiableList(false, ImmutableSponsoredMessages.createSafeList(elements, true, false));
        return new ImmutableSponsoredMessages(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableSponsoredMessages withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableSponsoredMessages.createUnmodifiableList(false, ImmutableSponsoredMessages.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSponsoredMessages(this.identifier, this.messages, newValue, this.users);
    }

    public final ImmutableSponsoredMessages withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableSponsoredMessages.createUnmodifiableList(false, ImmutableSponsoredMessages.createSafeList(elements, true, false));
        return new ImmutableSponsoredMessages(this.identifier, this.messages, newValue, this.users);
    }

    public final ImmutableSponsoredMessages withUsers(User ... elements) {
        List<User> newValue = ImmutableSponsoredMessages.createUnmodifiableList(false, ImmutableSponsoredMessages.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSponsoredMessages(this.identifier, this.messages, this.chats, newValue);
    }

    public final ImmutableSponsoredMessages withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableSponsoredMessages.createUnmodifiableList(false, ImmutableSponsoredMessages.createSafeList(elements, true, false));
        return new ImmutableSponsoredMessages(this.identifier, this.messages, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSponsoredMessages && this.equalTo(0, (ImmutableSponsoredMessages)another);
    }

    private boolean equalTo(int synthetic, ImmutableSponsoredMessages another) {
        return this.identifier == another.identifier && this.messages.equals(another.messages) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "SponsoredMessages{identifier=" + this.identifier + ", messages=" + this.messages + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableSponsoredMessages copyOf(SponsoredMessages instance) {
        if (instance instanceof ImmutableSponsoredMessages) {
            return (ImmutableSponsoredMessages)instance;
        }
        return ImmutableSponsoredMessages.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<SponsoredMessage> messages = new ArrayList<SponsoredMessage>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(SponsoredMessages instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SponsoredMessages instance;
            long bits = 0L;
            if (object instanceof SponsoredMessages) {
                instance = (SponsoredMessages)object;
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllMessages(instance.messages());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addMessage(SponsoredMessage element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(SponsoredMessage ... elements) {
            for (SponsoredMessage element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder messages(Iterable<? extends SponsoredMessage> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends SponsoredMessage> elements) {
            for (SponsoredMessage sponsoredMessage : elements) {
                this.messages.add(Objects.requireNonNull(sponsoredMessage, "messages element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableSponsoredMessages build() {
            return new ImmutableSponsoredMessages(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

