/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Document;
import telegram4j.tl.StickerPack;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.StickerSet;
import telegram4j.tl.messages.StickerSetWithDocuments;

public final class ImmutableStickerSet
implements StickerSet {
    private final int identifier;
    private final telegram4j.tl.StickerSet set;
    private final List<StickerPack> packs;
    private final List<Document> documents;

    private ImmutableStickerSet(telegram4j.tl.StickerSet set) {
        this.set = Objects.requireNonNull(set, "set");
        this.packs = Collections.emptyList();
        this.documents = Collections.emptyList();
        this.identifier = StickerSet.super.identifier();
    }

    private ImmutableStickerSet(Builder builder) {
        this.set = builder.set;
        this.packs = ImmutableStickerSet.createUnmodifiableList(true, builder.packs);
        this.documents = ImmutableStickerSet.createUnmodifiableList(true, builder.documents);
        this.identifier = builder.identifierIsSet() ? builder.identifier : StickerSet.super.identifier();
    }

    private ImmutableStickerSet(int identifier, telegram4j.tl.StickerSet set, List<StickerPack> packs, List<Document> documents) {
        this.identifier = identifier;
        this.set = set;
        this.packs = packs;
        this.documents = documents;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public telegram4j.tl.StickerSet set() {
        return this.set;
    }

    @Override
    public List<StickerPack> packs() {
        return this.packs;
    }

    @Override
    public List<Document> documents() {
        return this.documents;
    }

    public final ImmutableStickerSet withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStickerSet(value, this.set, this.packs, this.documents);
    }

    public final ImmutableStickerSet withSet(telegram4j.tl.StickerSet value) {
        if (this.set == value) {
            return this;
        }
        telegram4j.tl.StickerSet newValue = Objects.requireNonNull(value, "set");
        return new ImmutableStickerSet(this.identifier, newValue, this.packs, this.documents);
    }

    public final ImmutableStickerSet withPacks(StickerPack ... elements) {
        List<StickerPack> newValue = ImmutableStickerSet.createUnmodifiableList(false, ImmutableStickerSet.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableStickerSet(this.identifier, this.set, newValue, this.documents);
    }

    public final ImmutableStickerSet withPacks(Iterable<? extends StickerPack> elements) {
        if (this.packs == elements) {
            return this;
        }
        List<StickerPack> newValue = ImmutableStickerSet.createUnmodifiableList(false, ImmutableStickerSet.createSafeList(elements, true, false));
        return new ImmutableStickerSet(this.identifier, this.set, newValue, this.documents);
    }

    public final ImmutableStickerSet withDocuments(Document ... elements) {
        List<Document> newValue = ImmutableStickerSet.createUnmodifiableList(false, ImmutableStickerSet.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableStickerSet(this.identifier, this.set, this.packs, newValue);
    }

    public final ImmutableStickerSet withDocuments(Iterable<? extends Document> elements) {
        if (this.documents == elements) {
            return this;
        }
        List<Document> newValue = ImmutableStickerSet.createUnmodifiableList(false, ImmutableStickerSet.createSafeList(elements, true, false));
        return new ImmutableStickerSet(this.identifier, this.set, this.packs, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStickerSet && this.equalTo(0, (ImmutableStickerSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableStickerSet another) {
        return this.identifier == another.identifier && this.set.equals(another.set) && this.packs.equals(another.packs) && this.documents.equals(another.documents);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.set.hashCode();
        h += (h << 5) + this.packs.hashCode();
        h += (h << 5) + this.documents.hashCode();
        return h;
    }

    public String toString() {
        return "StickerSet{identifier=" + this.identifier + ", set=" + this.set + ", packs=" + this.packs + ", documents=" + this.documents + "}";
    }

    public static ImmutableStickerSet of(telegram4j.tl.StickerSet set) {
        return new ImmutableStickerSet(set);
    }

    public static ImmutableStickerSet copyOf(StickerSet instance) {
        if (instance instanceof ImmutableStickerSet) {
            return (ImmutableStickerSet)instance;
        }
        return ImmutableStickerSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SET = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private telegram4j.tl.StickerSet set;
        private List<StickerPack> packs = new ArrayList<StickerPack>();
        private List<Document> documents = new ArrayList<Document>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StickerSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StickerSetWithDocuments instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof StickerSet) {
                instance = (StickerSet)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.set(instance.set());
                this.addAllDocuments(instance.documents());
                this.addAllPacks(instance.packs());
            }
            if (object instanceof StickerSetWithDocuments) {
                instance = (StickerSetWithDocuments)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder set(telegram4j.tl.StickerSet set) {
            this.set = Objects.requireNonNull(set, "set");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPack(StickerPack element) {
            this.packs.add(Objects.requireNonNull(element, "packs element"));
            return this;
        }

        public final Builder addPacks(StickerPack ... elements) {
            for (StickerPack element : elements) {
                this.packs.add(Objects.requireNonNull(element, "packs element"));
            }
            return this;
        }

        public final Builder packs(Iterable<? extends StickerPack> elements) {
            this.packs.clear();
            return this.addAllPacks(elements);
        }

        public final Builder addAllPacks(Iterable<? extends StickerPack> elements) {
            for (StickerPack stickerPack : elements) {
                this.packs.add(Objects.requireNonNull(stickerPack, "packs element"));
            }
            return this;
        }

        public final Builder addDocument(Document element) {
            this.documents.add(Objects.requireNonNull(element, "documents element"));
            return this;
        }

        public final Builder addDocuments(Document ... elements) {
            for (Document element : elements) {
                this.documents.add(Objects.requireNonNull(element, "documents element"));
            }
            return this;
        }

        public final Builder documents(Iterable<? extends Document> elements) {
            this.documents.clear();
            return this.addAllDocuments(elements);
        }

        public final Builder addAllDocuments(Iterable<? extends Document> elements) {
            for (Document document : elements) {
                this.documents.add(Objects.requireNonNull(document, "documents element"));
            }
            return this;
        }

        public ImmutableStickerSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStickerSet(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("set");
            }
            return "Cannot build StickerSet, some of required attributes are not set " + attributes;
        }
    }
}

