/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.StickerSetCovered;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.StickerSetInstallResult;
import telegram4j.tl.messages.StickerSetInstallResultArchive;

public final class ImmutableStickerSetInstallResultArchive
implements StickerSetInstallResultArchive {
    private final int identifier;
    private final List<StickerSetCovered> sets;

    private ImmutableStickerSetInstallResultArchive(Builder builder) {
        this.sets = ImmutableStickerSetInstallResultArchive.createUnmodifiableList(true, builder.sets);
        this.identifier = builder.identifierIsSet() ? builder.identifier : StickerSetInstallResultArchive.super.identifier();
    }

    private ImmutableStickerSetInstallResultArchive(int identifier, List<StickerSetCovered> sets) {
        this.identifier = identifier;
        this.sets = sets;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<StickerSetCovered> sets() {
        return this.sets;
    }

    public final ImmutableStickerSetInstallResultArchive withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableStickerSetInstallResultArchive(value, this.sets);
    }

    public final ImmutableStickerSetInstallResultArchive withSets(StickerSetCovered ... elements) {
        List<StickerSetCovered> newValue = ImmutableStickerSetInstallResultArchive.createUnmodifiableList(false, ImmutableStickerSetInstallResultArchive.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableStickerSetInstallResultArchive(this.identifier, newValue);
    }

    public final ImmutableStickerSetInstallResultArchive withSets(Iterable<? extends StickerSetCovered> elements) {
        if (this.sets == elements) {
            return this;
        }
        List<StickerSetCovered> newValue = ImmutableStickerSetInstallResultArchive.createUnmodifiableList(false, ImmutableStickerSetInstallResultArchive.createSafeList(elements, true, false));
        return new ImmutableStickerSetInstallResultArchive(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStickerSetInstallResultArchive && this.equalTo(0, (ImmutableStickerSetInstallResultArchive)another);
    }

    private boolean equalTo(int synthetic, ImmutableStickerSetInstallResultArchive another) {
        return this.identifier == another.identifier && this.sets.equals(another.sets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.sets.hashCode();
        return h;
    }

    public String toString() {
        return "StickerSetInstallResultArchive{identifier=" + this.identifier + ", sets=" + this.sets + "}";
    }

    public static ImmutableStickerSetInstallResultArchive copyOf(StickerSetInstallResultArchive instance) {
        if (instance instanceof ImmutableStickerSetInstallResultArchive) {
            return (ImmutableStickerSetInstallResultArchive)instance;
        }
        return ImmutableStickerSetInstallResultArchive.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<StickerSetCovered> sets = new ArrayList<StickerSetCovered>();

        private Builder() {
        }

        public final Builder from(StickerSetInstallResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(StickerSetInstallResultArchive instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StickerSetInstallResult instance;
            long bits = 0L;
            if (object instanceof StickerSetInstallResult) {
                instance = (StickerSetInstallResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof StickerSetInstallResultArchive) {
                instance = (StickerSetInstallResultArchive)object;
                this.addAllSets(instance.sets());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addSet(StickerSetCovered element) {
            this.sets.add(Objects.requireNonNull(element, "sets element"));
            return this;
        }

        public final Builder addSets(StickerSetCovered ... elements) {
            for (StickerSetCovered element : elements) {
                this.sets.add(Objects.requireNonNull(element, "sets element"));
            }
            return this;
        }

        public final Builder sets(Iterable<? extends StickerSetCovered> elements) {
            this.sets.clear();
            return this.addAllSets(elements);
        }

        public final Builder addAllSets(Iterable<? extends StickerSetCovered> elements) {
            for (StickerSetCovered stickerSetCovered : elements) {
                this.sets.add(Objects.requireNonNull(stickerSetCovered, "sets element"));
            }
            return this;
        }

        public ImmutableStickerSetInstallResultArchive build() {
            return new ImmutableStickerSetInstallResultArchive(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

