/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.TranscribedAudio;

public final class ImmutableTranscribedAudio
implements TranscribedAudio {
    private final int identifier;
    private final int flags;
    private final boolean pending;
    private final long transcriptionId;
    private final String text;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTranscribedAudio(long transcriptionId, String text) {
        this.transcriptionId = transcriptionId;
        this.text = Objects.requireNonNull(text, "text");
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pending = this.initShim.pending();
        this.initShim = null;
    }

    private ImmutableTranscribedAudio(Builder builder) {
        this.transcriptionId = builder.transcriptionId;
        this.text = builder.text;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.pendingIsSet()) {
            this.initShim.pending(builder.pending);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.pending = this.initShim.pending();
        this.initShim = null;
    }

    private ImmutableTranscribedAudio(int identifier, int flags, boolean pending, long transcriptionId, String text) {
        this.identifier = identifier;
        this.flags = flags;
        this.pending = pending;
        this.transcriptionId = transcriptionId;
        this.text = text;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return TranscribedAudio.super.identifier();
    }

    private int flagsInitialize() {
        return TranscribedAudio.super.flags();
    }

    private boolean pendingInitialize() {
        return TranscribedAudio.super.pending();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean pending() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pending() : this.pending;
    }

    @Override
    public long transcriptionId() {
        return this.transcriptionId;
    }

    @Override
    public String text() {
        return this.text;
    }

    public final ImmutableTranscribedAudio withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableTranscribedAudio(value, this.flags, this.pending, this.transcriptionId, this.text);
    }

    public final ImmutableTranscribedAudio withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableTranscribedAudio(this.identifier, value, this.pending, this.transcriptionId, this.text);
    }

    public final ImmutableTranscribedAudio withPending(boolean value) {
        if (this.pending == value) {
            return this;
        }
        return new ImmutableTranscribedAudio(this.identifier, this.flags, value, this.transcriptionId, this.text);
    }

    public final ImmutableTranscribedAudio withTranscriptionId(long value) {
        if (this.transcriptionId == value) {
            return this;
        }
        return new ImmutableTranscribedAudio(this.identifier, this.flags, this.pending, value, this.text);
    }

    public final ImmutableTranscribedAudio withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableTranscribedAudio(this.identifier, this.flags, this.pending, this.transcriptionId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTranscribedAudio && this.equalTo(0, (ImmutableTranscribedAudio)another);
    }

    private boolean equalTo(int synthetic, ImmutableTranscribedAudio another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.pending == another.pending && this.transcriptionId == another.transcriptionId && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.pending);
        h += (h << 5) + Long.hashCode(this.transcriptionId);
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return "TranscribedAudio{identifier=" + this.identifier + ", flags=" + this.flags + ", pending=" + this.pending + ", transcriptionId=" + this.transcriptionId + ", text=" + this.text + "}";
    }

    public static ImmutableTranscribedAudio of(long transcriptionId, String text) {
        return new ImmutableTranscribedAudio(transcriptionId, text);
    }

    public static ImmutableTranscribedAudio copyOf(TranscribedAudio instance) {
        if (instance instanceof ImmutableTranscribedAudio) {
            return (ImmutableTranscribedAudio)instance;
        }
        return ImmutableTranscribedAudio.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TRANSCRIPTION_ID = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_PENDING = 4L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean pending;
        private long transcriptionId;
        private String text;

        private Builder() {
        }

        public final Builder from(TranscribedAudio instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TranscribedAudio instance;
            long bits = 0L;
            if (object instanceof TranscribedAudio) {
                instance = (TranscribedAudio)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.text(instance.text());
                this.pending(instance.pending());
                this.transcriptionId(instance.transcriptionId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder pending(boolean pending) {
            this.pending = pending;
            this.optBits |= 4L;
            return this;
        }

        public final Builder transcriptionId(long transcriptionId) {
            this.transcriptionId = transcriptionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTranscribedAudio build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTranscribedAudio(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pendingIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transcriptionId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build TranscribedAudio, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte pendingBuildStage = 0;
        private boolean pending;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableTranscribedAudio.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableTranscribedAudio.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean pending() {
            if (this.pendingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pendingBuildStage == 0) {
                this.pendingBuildStage = (byte)-1;
                this.pending = ImmutableTranscribedAudio.this.pendingInitialize();
                this.pendingBuildStage = 1;
            }
            return this.pending;
        }

        void pending(boolean pending) {
            this.pending = pending;
            this.pendingBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.pendingBuildStage == -1) {
                attributes.add("pending");
            }
            return "Cannot build TranscribedAudio, attribute initializers form cycle " + attributes;
        }
    }
}

