/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.TranslateNoResult;
import telegram4j.tl.messages.TranslatedText;

public final class ImmutableTranslateNoResult
implements TranslateNoResult {
    private final int identifier;
    private static final ImmutableTranslateNoResult INSTANCE = ImmutableTranslateNoResult.validate(new ImmutableTranslateNoResult());

    private ImmutableTranslateNoResult() {
        this.identifier = TranslateNoResult.super.identifier();
    }

    private ImmutableTranslateNoResult(Builder builder) {
        this.identifier = builder.identifierIsSet() ? builder.identifier : TranslateNoResult.super.identifier();
    }

    private ImmutableTranslateNoResult(int identifier) {
        this.identifier = identifier;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    public final ImmutableTranslateNoResult withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableTranslateNoResult.validate(new ImmutableTranslateNoResult(value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTranslateNoResult && this.equalTo(0, (ImmutableTranslateNoResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableTranslateNoResult another) {
        return this.identifier == another.identifier;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        return h;
    }

    public String toString() {
        return "TranslateNoResult{identifier=" + this.identifier + "}";
    }

    public static ImmutableTranslateNoResult of() {
        return INSTANCE;
    }

    private static ImmutableTranslateNoResult validate(ImmutableTranslateNoResult instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableTranslateNoResult copyOf(TranslateNoResult instance) {
        if (instance instanceof ImmutableTranslateNoResult) {
            return (ImmutableTranslateNoResult)instance;
        }
        return ImmutableTranslateNoResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TranslateNoResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TranslatedText instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TranslatedText instance;
            long bits = 0L;
            if (object instanceof TranslateNoResult) {
                instance = (TranslateNoResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TranslatedText) {
                instance = (TranslatedText)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableTranslateNoResult build() {
            return ImmutableTranslateNoResult.validate(new ImmutableTranslateNoResult(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

