/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.messages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.MessageUserVote;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.messages.VotesList;

public final class ImmutableVotesList
implements VotesList {
    private final int identifier;
    private final int flags;
    private final int count;
    private final List<MessageUserVote> votes;
    private final List<User> users;
    @Nullable
    private final String nextOffset;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableVotesList(int count) {
        this.count = count;
        this.votes = Collections.emptyList();
        this.users = Collections.emptyList();
        this.nextOffset = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableVotesList(Builder builder) {
        this.count = builder.count;
        this.votes = ImmutableVotesList.createUnmodifiableList(true, builder.votes);
        this.users = ImmutableVotesList.createUnmodifiableList(true, builder.users);
        this.nextOffset = builder.nextOffset;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableVotesList(int identifier, int flags, int count, List<MessageUserVote> votes, List<User> users, @Nullable String nextOffset) {
        this.identifier = identifier;
        this.flags = flags;
        this.count = count;
        this.votes = votes;
        this.users = users;
        this.nextOffset = nextOffset;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return VotesList.super.identifier();
    }

    private int flagsInitialize() {
        return VotesList.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<MessageUserVote> votes() {
        return this.votes;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    @Override
    @Nullable
    public String nextOffset() {
        return this.nextOffset;
    }

    public final ImmutableVotesList withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableVotesList(value, this.flags, this.count, this.votes, this.users, this.nextOffset);
    }

    public final ImmutableVotesList withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableVotesList(this.identifier, value, this.count, this.votes, this.users, this.nextOffset);
    }

    public final ImmutableVotesList withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableVotesList(this.identifier, this.flags, value, this.votes, this.users, this.nextOffset);
    }

    public final ImmutableVotesList withVotes(MessageUserVote ... elements) {
        List<MessageUserVote> newValue = ImmutableVotesList.createUnmodifiableList(false, ImmutableVotesList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableVotesList(this.identifier, this.flags, this.count, newValue, this.users, this.nextOffset);
    }

    public final ImmutableVotesList withVotes(Iterable<? extends MessageUserVote> elements) {
        if (this.votes == elements) {
            return this;
        }
        List<MessageUserVote> newValue = ImmutableVotesList.createUnmodifiableList(false, ImmutableVotesList.createSafeList(elements, true, false));
        return new ImmutableVotesList(this.identifier, this.flags, this.count, newValue, this.users, this.nextOffset);
    }

    public final ImmutableVotesList withUsers(User ... elements) {
        List<User> newValue = ImmutableVotesList.createUnmodifiableList(false, ImmutableVotesList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableVotesList(this.identifier, this.flags, this.count, this.votes, newValue, this.nextOffset);
    }

    public final ImmutableVotesList withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableVotesList.createUnmodifiableList(false, ImmutableVotesList.createSafeList(elements, true, false));
        return new ImmutableVotesList(this.identifier, this.flags, this.count, this.votes, newValue, this.nextOffset);
    }

    public final ImmutableVotesList withNextOffset(@Nullable String value) {
        if (Objects.equals(this.nextOffset, value)) {
            return this;
        }
        return new ImmutableVotesList(this.identifier, this.flags, this.count, this.votes, this.users, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVotesList && this.equalTo(0, (ImmutableVotesList)another);
    }

    private boolean equalTo(int synthetic, ImmutableVotesList another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.count == another.count && this.votes.equals(another.votes) && this.users.equals(another.users) && Objects.equals(this.nextOffset, another.nextOffset);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.count;
        h += (h << 5) + this.votes.hashCode();
        h += (h << 5) + this.users.hashCode();
        h += (h << 5) + Objects.hashCode(this.nextOffset);
        return h;
    }

    public String toString() {
        return "VotesList{identifier=" + this.identifier + ", flags=" + this.flags + ", count=" + this.count + ", votes=" + this.votes + ", users=" + this.users + ", nextOffset=" + this.nextOffset + "}";
    }

    public static ImmutableVotesList of(int count) {
        return new ImmutableVotesList(count);
    }

    public static ImmutableVotesList copyOf(VotesList instance) {
        if (instance instanceof ImmutableVotesList) {
            return (ImmutableVotesList)instance;
        }
        return ImmutableVotesList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private int count;
        private List<MessageUserVote> votes = new ArrayList<MessageUserVote>();
        private List<User> users = new ArrayList<User>();
        private String nextOffset;

        private Builder() {
        }

        public final Builder from(VotesList instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            VotesList instance;
            long bits = 0L;
            if (object instanceof VotesList) {
                instance = (VotesList)object;
                this.flags(instance.flags());
                this.count(instance.count());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllVotes(instance.votes());
                String nextOffsetValue = instance.nextOffset();
                if (nextOffsetValue != null) {
                    this.nextOffset(nextOffsetValue);
                }
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addVote(MessageUserVote element) {
            this.votes.add(Objects.requireNonNull(element, "votes element"));
            return this;
        }

        public final Builder addVotes(MessageUserVote ... elements) {
            for (MessageUserVote element : elements) {
                this.votes.add(Objects.requireNonNull(element, "votes element"));
            }
            return this;
        }

        public final Builder votes(Iterable<? extends MessageUserVote> elements) {
            this.votes.clear();
            return this.addAllVotes(elements);
        }

        public final Builder addAllVotes(Iterable<? extends MessageUserVote> elements) {
            for (MessageUserVote messageUserVote : elements) {
                this.votes.add(Objects.requireNonNull(messageUserVote, "votes element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public final Builder nextOffset(@Nullable String nextOffset) {
            this.nextOffset = nextOffset;
            return this;
        }

        public ImmutableVotesList build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVotesList(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build VotesList, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableVotesList.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableVotesList.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build VotesList, attribute initializers form cycle " + attributes;
        }
    }
}

