/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.BadMsgNotification;
import telegram4j.tl.mtproto.BadServerSalt;

public final class ImmutableBadServerSalt
implements BadServerSalt {
    private final int identifier;
    private final long badMsgId;
    private final int badMsgSeqno;
    private final int errorCode;
    private final long newServerSalt;

    private ImmutableBadServerSalt(long badMsgId, int badMsgSeqno, int errorCode, long newServerSalt) {
        this.badMsgId = badMsgId;
        this.badMsgSeqno = badMsgSeqno;
        this.errorCode = errorCode;
        this.newServerSalt = newServerSalt;
        this.identifier = BadServerSalt.super.identifier();
    }

    private ImmutableBadServerSalt(Builder builder) {
        this.badMsgId = builder.badMsgId;
        this.badMsgSeqno = builder.badMsgSeqno;
        this.errorCode = builder.errorCode;
        this.newServerSalt = builder.newServerSalt;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BadServerSalt.super.identifier();
    }

    private ImmutableBadServerSalt(int identifier, long badMsgId, int badMsgSeqno, int errorCode, long newServerSalt) {
        this.identifier = identifier;
        this.badMsgId = badMsgId;
        this.badMsgSeqno = badMsgSeqno;
        this.errorCode = errorCode;
        this.newServerSalt = newServerSalt;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long badMsgId() {
        return this.badMsgId;
    }

    @Override
    public int badMsgSeqno() {
        return this.badMsgSeqno;
    }

    @Override
    public int errorCode() {
        return this.errorCode;
    }

    @Override
    public long newServerSalt() {
        return this.newServerSalt;
    }

    public final ImmutableBadServerSalt withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBadServerSalt(value, this.badMsgId, this.badMsgSeqno, this.errorCode, this.newServerSalt);
    }

    public final ImmutableBadServerSalt withBadMsgId(long value) {
        if (this.badMsgId == value) {
            return this;
        }
        return new ImmutableBadServerSalt(this.identifier, value, this.badMsgSeqno, this.errorCode, this.newServerSalt);
    }

    public final ImmutableBadServerSalt withBadMsgSeqno(int value) {
        if (this.badMsgSeqno == value) {
            return this;
        }
        return new ImmutableBadServerSalt(this.identifier, this.badMsgId, value, this.errorCode, this.newServerSalt);
    }

    public final ImmutableBadServerSalt withErrorCode(int value) {
        if (this.errorCode == value) {
            return this;
        }
        return new ImmutableBadServerSalt(this.identifier, this.badMsgId, this.badMsgSeqno, value, this.newServerSalt);
    }

    public final ImmutableBadServerSalt withNewServerSalt(long value) {
        if (this.newServerSalt == value) {
            return this;
        }
        return new ImmutableBadServerSalt(this.identifier, this.badMsgId, this.badMsgSeqno, this.errorCode, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBadServerSalt && this.equalTo(0, (ImmutableBadServerSalt)another);
    }

    private boolean equalTo(int synthetic, ImmutableBadServerSalt another) {
        return this.identifier == another.identifier && this.badMsgId == another.badMsgId && this.badMsgSeqno == another.badMsgSeqno && this.errorCode == another.errorCode && this.newServerSalt == another.newServerSalt;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.badMsgId);
        h += (h << 5) + this.badMsgSeqno;
        h += (h << 5) + this.errorCode;
        h += (h << 5) + Long.hashCode(this.newServerSalt);
        return h;
    }

    public String toString() {
        return "BadServerSalt{identifier=" + this.identifier + ", badMsgId=" + this.badMsgId + ", badMsgSeqno=" + this.badMsgSeqno + ", errorCode=" + this.errorCode + ", newServerSalt=" + this.newServerSalt + "}";
    }

    public static ImmutableBadServerSalt of(long badMsgId, int badMsgSeqno, int errorCode, long newServerSalt) {
        return new ImmutableBadServerSalt(badMsgId, badMsgSeqno, errorCode, newServerSalt);
    }

    public static ImmutableBadServerSalt copyOf(BadServerSalt instance) {
        if (instance instanceof ImmutableBadServerSalt) {
            return (ImmutableBadServerSalt)instance;
        }
        return ImmutableBadServerSalt.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BAD_MSG_ID = 1L;
        private static final long INIT_BIT_BAD_MSG_SEQNO = 2L;
        private static final long INIT_BIT_ERROR_CODE = 4L;
        private static final long INIT_BIT_NEW_SERVER_SALT = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long badMsgId;
        private int badMsgSeqno;
        private int errorCode;
        private long newServerSalt;

        private Builder() {
        }

        public final Builder from(BadServerSalt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BadMsgNotification instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BadMsgNotification instance;
            long bits = 0L;
            if (object instanceof BadServerSalt) {
                instance = (BadServerSalt)object;
                if ((bits & 1L) == 0L) {
                    this.badMsgId(instance.badMsgId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.errorCode(instance.errorCode());
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    this.badMsgSeqno(instance.badMsgSeqno());
                    bits |= 4L;
                }
                this.newServerSalt(instance.newServerSalt());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
            if (object instanceof BadMsgNotification) {
                instance = (BadMsgNotification)object;
                if ((bits & 1L) == 0L) {
                    this.badMsgId(instance.badMsgId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.errorCode(instance.errorCode());
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    this.badMsgSeqno(instance.badMsgSeqno());
                    bits |= 4L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder badMsgId(long badMsgId) {
            this.badMsgId = badMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder badMsgSeqno(int badMsgSeqno) {
            this.badMsgSeqno = badMsgSeqno;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder errorCode(int errorCode) {
            this.errorCode = errorCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder newServerSalt(long newServerSalt) {
            this.newServerSalt = newServerSalt;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableBadServerSalt build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBadServerSalt(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("badMsgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("badMsgSeqno");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("errorCode");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("newServerSalt");
            }
            return "Cannot build BadServerSalt, some of required attributes are not set " + attributes;
        }
    }
}

