/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.BadMsgNotification;
import telegram4j.tl.mtproto.BaseBadMsgNotification;

public final class ImmutableBaseBadMsgNotification
implements BaseBadMsgNotification {
    private final int identifier;
    private final long badMsgId;
    private final int badMsgSeqno;
    private final int errorCode;

    private ImmutableBaseBadMsgNotification(long badMsgId, int badMsgSeqno, int errorCode) {
        this.badMsgId = badMsgId;
        this.badMsgSeqno = badMsgSeqno;
        this.errorCode = errorCode;
        this.identifier = BaseBadMsgNotification.super.identifier();
    }

    private ImmutableBaseBadMsgNotification(Builder builder) {
        this.badMsgId = builder.badMsgId;
        this.badMsgSeqno = builder.badMsgSeqno;
        this.errorCode = builder.errorCode;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseBadMsgNotification.super.identifier();
    }

    private ImmutableBaseBadMsgNotification(int identifier, long badMsgId, int badMsgSeqno, int errorCode) {
        this.identifier = identifier;
        this.badMsgId = badMsgId;
        this.badMsgSeqno = badMsgSeqno;
        this.errorCode = errorCode;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long badMsgId() {
        return this.badMsgId;
    }

    @Override
    public int badMsgSeqno() {
        return this.badMsgSeqno;
    }

    @Override
    public int errorCode() {
        return this.errorCode;
    }

    public final ImmutableBaseBadMsgNotification withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseBadMsgNotification(value, this.badMsgId, this.badMsgSeqno, this.errorCode);
    }

    public final ImmutableBaseBadMsgNotification withBadMsgId(long value) {
        if (this.badMsgId == value) {
            return this;
        }
        return new ImmutableBaseBadMsgNotification(this.identifier, value, this.badMsgSeqno, this.errorCode);
    }

    public final ImmutableBaseBadMsgNotification withBadMsgSeqno(int value) {
        if (this.badMsgSeqno == value) {
            return this;
        }
        return new ImmutableBaseBadMsgNotification(this.identifier, this.badMsgId, value, this.errorCode);
    }

    public final ImmutableBaseBadMsgNotification withErrorCode(int value) {
        if (this.errorCode == value) {
            return this;
        }
        return new ImmutableBaseBadMsgNotification(this.identifier, this.badMsgId, this.badMsgSeqno, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseBadMsgNotification && this.equalTo(0, (ImmutableBaseBadMsgNotification)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseBadMsgNotification another) {
        return this.identifier == another.identifier && this.badMsgId == another.badMsgId && this.badMsgSeqno == another.badMsgSeqno && this.errorCode == another.errorCode;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.badMsgId);
        h += (h << 5) + this.badMsgSeqno;
        h += (h << 5) + this.errorCode;
        return h;
    }

    public String toString() {
        return "BaseBadMsgNotification{identifier=" + this.identifier + ", badMsgId=" + this.badMsgId + ", badMsgSeqno=" + this.badMsgSeqno + ", errorCode=" + this.errorCode + "}";
    }

    public static ImmutableBaseBadMsgNotification of(long badMsgId, int badMsgSeqno, int errorCode) {
        return new ImmutableBaseBadMsgNotification(badMsgId, badMsgSeqno, errorCode);
    }

    public static ImmutableBaseBadMsgNotification copyOf(BaseBadMsgNotification instance) {
        if (instance instanceof ImmutableBaseBadMsgNotification) {
            return (ImmutableBaseBadMsgNotification)instance;
        }
        return ImmutableBaseBadMsgNotification.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_BAD_MSG_ID = 1L;
        private static final long INIT_BIT_BAD_MSG_SEQNO = 2L;
        private static final long INIT_BIT_ERROR_CODE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long badMsgId;
        private int badMsgSeqno;
        private int errorCode;

        private Builder() {
        }

        public final Builder from(BaseBadMsgNotification instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BadMsgNotification instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BadMsgNotification instance;
            long bits = 0L;
            if (object instanceof BaseBadMsgNotification) {
                instance = (BaseBadMsgNotification)object;
                if ((bits & 1L) == 0L) {
                    this.badMsgId(instance.badMsgId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.errorCode(instance.errorCode());
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    this.badMsgSeqno(instance.badMsgSeqno());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
            if (object instanceof BadMsgNotification) {
                instance = (BadMsgNotification)object;
                if ((bits & 1L) == 0L) {
                    this.badMsgId(instance.badMsgId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.errorCode(instance.errorCode());
                    bits |= 8L;
                }
                if ((bits & 4L) == 0L) {
                    this.badMsgSeqno(instance.badMsgSeqno());
                    bits |= 4L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder badMsgId(long badMsgId) {
            this.badMsgId = badMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder badMsgSeqno(int badMsgSeqno) {
            this.badMsgSeqno = badMsgSeqno;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder errorCode(int errorCode) {
            this.errorCode = errorCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableBaseBadMsgNotification build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseBadMsgNotification(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("badMsgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("badMsgSeqno");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("errorCode");
            }
            return "Cannot build BaseBadMsgNotification, some of required attributes are not set " + attributes;
        }
    }
}

