/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.BaseMsgDetailedInfo;
import telegram4j.tl.mtproto.MsgDetailedInfo;

public final class ImmutableBaseMsgDetailedInfo
implements BaseMsgDetailedInfo {
    private final int identifier;
    private final long msgId;
    private final long answerMsgId;
    private final int bytes;
    private final int status;

    private ImmutableBaseMsgDetailedInfo(long msgId, long answerMsgId, int bytes, int status) {
        this.msgId = msgId;
        this.answerMsgId = answerMsgId;
        this.bytes = bytes;
        this.status = status;
        this.identifier = BaseMsgDetailedInfo.super.identifier();
    }

    private ImmutableBaseMsgDetailedInfo(Builder builder) {
        this.msgId = builder.msgId;
        this.answerMsgId = builder.answerMsgId;
        this.bytes = builder.bytes;
        this.status = builder.status;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BaseMsgDetailedInfo.super.identifier();
    }

    private ImmutableBaseMsgDetailedInfo(int identifier, long msgId, long answerMsgId, int bytes, int status) {
        this.identifier = identifier;
        this.msgId = msgId;
        this.answerMsgId = answerMsgId;
        this.bytes = bytes;
        this.status = status;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long msgId() {
        return this.msgId;
    }

    @Override
    public long answerMsgId() {
        return this.answerMsgId;
    }

    @Override
    public int bytes() {
        return this.bytes;
    }

    @Override
    public int status() {
        return this.status;
    }

    public final ImmutableBaseMsgDetailedInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBaseMsgDetailedInfo(value, this.msgId, this.answerMsgId, this.bytes, this.status);
    }

    public final ImmutableBaseMsgDetailedInfo withMsgId(long value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableBaseMsgDetailedInfo(this.identifier, value, this.answerMsgId, this.bytes, this.status);
    }

    public final ImmutableBaseMsgDetailedInfo withAnswerMsgId(long value) {
        if (this.answerMsgId == value) {
            return this;
        }
        return new ImmutableBaseMsgDetailedInfo(this.identifier, this.msgId, value, this.bytes, this.status);
    }

    public final ImmutableBaseMsgDetailedInfo withBytes(int value) {
        if (this.bytes == value) {
            return this;
        }
        return new ImmutableBaseMsgDetailedInfo(this.identifier, this.msgId, this.answerMsgId, value, this.status);
    }

    public final ImmutableBaseMsgDetailedInfo withStatus(int value) {
        if (this.status == value) {
            return this;
        }
        return new ImmutableBaseMsgDetailedInfo(this.identifier, this.msgId, this.answerMsgId, this.bytes, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaseMsgDetailedInfo && this.equalTo(0, (ImmutableBaseMsgDetailedInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaseMsgDetailedInfo another) {
        return this.identifier == another.identifier && this.msgId == another.msgId && this.answerMsgId == another.answerMsgId && this.bytes == another.bytes && this.status == another.status;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.msgId);
        h += (h << 5) + Long.hashCode(this.answerMsgId);
        h += (h << 5) + this.bytes;
        h += (h << 5) + this.status;
        return h;
    }

    public String toString() {
        return "BaseMsgDetailedInfo{identifier=" + this.identifier + ", msgId=" + this.msgId + ", answerMsgId=" + this.answerMsgId + ", bytes=" + this.bytes + ", status=" + this.status + "}";
    }

    public static ImmutableBaseMsgDetailedInfo of(long msgId, long answerMsgId, int bytes, int status) {
        return new ImmutableBaseMsgDetailedInfo(msgId, answerMsgId, bytes, status);
    }

    public static ImmutableBaseMsgDetailedInfo copyOf(BaseMsgDetailedInfo instance) {
        if (instance instanceof ImmutableBaseMsgDetailedInfo) {
            return (ImmutableBaseMsgDetailedInfo)instance;
        }
        return ImmutableBaseMsgDetailedInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MSG_ID = 1L;
        private static final long INIT_BIT_ANSWER_MSG_ID = 2L;
        private static final long INIT_BIT_BYTES = 4L;
        private static final long INIT_BIT_STATUS = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long msgId;
        private long answerMsgId;
        private int bytes;
        private int status;

        private Builder() {
        }

        public final Builder from(MsgDetailedInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseMsgDetailedInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MsgDetailedInfo instance;
            long bits = 0L;
            if (object instanceof MsgDetailedInfo) {
                instance = (MsgDetailedInfo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.bytes(instance.bytes());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.answerMsgId(instance.answerMsgId());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.status(instance.status());
                    bits |= 8L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BaseMsgDetailedInfo) {
                instance = (BaseMsgDetailedInfo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                if ((bits & 2L) == 0L) {
                    this.bytes(instance.bytes());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.answerMsgId(instance.answerMsgId());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.status(instance.status());
                    bits |= 8L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder msgId(long msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder answerMsgId(long answerMsgId) {
            this.answerMsgId = answerMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bytes(int bytes) {
            this.bytes = bytes;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder status(int status) {
            this.status = status;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableBaseMsgDetailedInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaseMsgDetailedInfo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("answerMsgId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bytes");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build BaseMsgDetailedInfo, some of required attributes are not set " + attributes;
        }
    }
}

